//device_info_item 템플릿으로 부터 디바이스 리스트 아이템을 생성한다.
function getDeviceInfoItem(name, reg_date, is_current_device, index) {
	var t = document.querySelector('#device_info_item');
	var clone = document.importNode(t.content, true);
	clone.querySelector('.name').textContent = name;
	clone.querySelector('.date').textContent = convertLocaleTimeFormat(reg_date);
	clone.querySelector('.btn_edit').addEventListener('click', function () {
		setInputDeviceName(name);
		setChangeNameIndex(index);
		setEnableDeviceNameChangePopup(true);
		//location.href = "hivesdk://ui?button=change_device_name&index="+index;
	});
	if (is_current_device) {
		clone.querySelector('#device_info_head').classList.add('connecting')
		//현재 디바이스는 버튼 활성화 off
		clone.querySelector('.btn_delete').classList.add('btn_off')
	} else {
		clone.querySelector('.btn_delete').classList.add('btn_on')
		clone.querySelector('.btn_delete').addEventListener('click', function () {
			setRemoveDeviceIndex(index);
			setEnableDeviceRemovePopup(true);
			//location.href = "hivesdk://ui?button=delete_device&index="+index;
		});
	}
	return clone;
}
//디바이스 리스트 설정
// param : array
// deviceList.name : 디바이스 이름
// deviceList.reg_date : 디바이스 등록일
// deviceList.is_current_device : 현재 디바이스 여부
function setDeviceList(deviceList) {
	var index = 0;
	document.querySelector('.my_device').innerHTML = "";
	deviceList.forEach(element => {
		var item = getDeviceInfoItem(element.name, element.reg_date, element.is_current_device, index);
		document.querySelector('.my_device').appendChild(item);
		index++;
	});
}

function convertLocaleTimeFormat(dateString) {
	let date = new Date(dateString);
	/**
	 * 2021. 12. 10. 에서 마지막 닷(.) 지우기
	 */
	let lastDotRegex = new RegExp(/(\.$)|(\. $)/, 'g');

	/**
	 * 숫자를 제외한 하이픈이 아닌 문자열을 모두 하이픈으로 바꾸기
	 */
	let replaceDash = new RegExp(/(\. )|[-/\.]/, 'g');

	const options = { year: 'numeric', month: '2-digit', day: '2-digit' };
	var phone_num = date.toLocaleDateString(locales, options);
	phone_num = phone_num.replace(lastDotRegex, '');
	phone_num = phone_num.replace(replaceDash, '-');
	return phone_num;
}

// 팝업관련 함수들
function hideAllPopup() {
	setEnableDeviceRemovePopup(false)
	setEnableDeviceRemoveErrorPopup(false)
	setEnableDeviceNameChangePopup(false)
	setEnableDeviceNameChangeErrorPopup(false)
	setErrorMessagePopup(false)
}

function setEnablePopup(element, enable) {
	var popup = element;
	if (enable) {
		popup.style.display = "flex";
	} else {
		popup.style.display = "none";
	}
	// if (enable && popup.classList.contains('hide')) {
	// 	popup.classList.remove('hide');
	// } else if (!enable && !popup.classList.contains('hide')) {
	// 	popup.classList.add('hide');
	// }

}
function setEnableDeviceRemovePopup(enable) {
	var element = document.querySelector('#device_remove_popup');
	setEnablePopup(element, enable);
}

function setEnableDeviceRemoveErrorPopup(enable, error_code) {
	var element = document.querySelector('#device_remove_failed_popup');
	setEnablePopup(element, enable);
	element.querySelector('.error_text').textContent = '[' + error_code + ']';
}

function setEnableDeviceNameChangePopup(enable) {
	var element = document.querySelector('#device_name_change_popup');
	setEnablePopup(element, enable);
	if (enable) {
		updateNameChangeButton();
	}
}

function setEnableDeviceNameChangeErrorPopup(enable, error_code) {
	var element = document.querySelector('#device_name_change_failed_popup');
	setEnablePopup(element, enable);
	element.querySelector('.error_text').textContent = '[' + error_code + ']';
}

function setErrorMessagePopup(enable, error_message) {
	var element = document.querySelector('#error_message_poup');
	setEnablePopup(element, enable);
	element.querySelector('.pop_desc').innerHTML = error_message;
}

function setMaxDeviceCount(maxCount) {
	s1 = String(document.querySelector('ul.pop_note > li:nth-child(1)').textContent);
	s1 = s1.replace("%d", String(maxCount));
	s2 = String(document.querySelector('ul.pop_note > li:nth-child(2)').textContent);
	s2 = s2.replace("%d", String(maxCount));

	document.querySelector('ul.pop_note > li:nth-child(1)').textContent = s1;
	document.querySelector('ul.pop_note > li:nth-child(2)').textContent = s2;
}

function setInputDeviceName(value) {
	document.querySelector('#change_device_input').value = value;
}

function getInputDeviceName() {
	return document.querySelector('#change_device_input').value;
}

var changeNameIndex = 0;
function setChangeNameIndex(index) {
	changeNameIndex = index;
}
function getChangeNameIndex() {
	return changeNameIndex;
}

var removeIndex = 0;
function setRemoveDeviceIndex(index) {
	removeIndex = index;
}
function getRemoveDeviceIndex() {
	return removeIndex;
}

function onChangeNameBtn() {
	if (nameChangeBtnEnable) {
		location.href = 'hivesdk://ui?button=change_device_name&index=' + getChangeNameIndex() + '&name=' + encodeURIComponent(getInputDeviceName())
	}
}

function updateNameChangeButton() {
	if (getInputDeviceName() <= 0) {
		setEnablePhoneNameChangeButton(false)
	} else {
		setEnablePhoneNameChangeButton(true)
	}
}

var nameChangeBtnEnable = false;
function setEnablePhoneNameChangeButton(enable) {
	nameChangeBtnEnable = enable;
	var element = document.querySelector("#device_name_change_popup > div > div > div > div.btns > div:nth-child(2) > button");
	if (enable) {
		if (!element.classList.contains('btn_on')) {
			element.classList.remove('btn_off');
			element.classList.add('btn_on');
		}
	} else {
		if (!element.classList.contains('btn_off')) {
			element.classList.remove('btn_on');
			element.classList.add('btn_off');
		}
	}
}

function numberMaxLength(e) {
	if (e.value.length > e.maxLength) {
		e.value = e.value.slice(0, e.maxLength);
	}
}

window.addEventListener('load', function () {
	document.querySelector('#change_device_input').addEventListener('input', function () {
		updateNameChangeButton();
	});
})