function removeErrorPopup() {
    var errorPopup = document.getElementById("error_popup");
    if (errorPopup) {
        errorPopup.remove();
    }
}
function setPopupError(error_title, error_content, confirm_msg) {
    removeErrorPopup();

    if ('content' in document.createElement('template')) {
        var error_box = document.getElementById("popup_error_layer");
        var t = document.querySelector('#popup_error');
        var clone = document.importNode(t.content, true);
        var errorTitleElem = clone.querySelector(".pop_tit");
        var errorMsgElem = clone.querySelector(".pop_note");
        var errorBtnElem = clone.querySelector(".btn_confirm");

        if (!error_title) {
            errorTitleElem.remove();
        } else {
            errorTitleElem.textContent = error_title;
        }

        errorMsgElem.innerHTML = error_content;
        errorBtnElem.textContent = confirm_msg;
        error_box.prepend(clone);
    }
}

let element_email_error_id = "email_error"
let element_password_error_id = "pw_error"
function setEmailError(error) {
    var elem = document.getElementById(element_email_error_id);
    insertInputErrorBox(elem, error);
}
function setPasswordError(error) {
    var elem = document.getElementById(element_password_error_id);
    insertInputErrorBox(elem, error);
}

function removeEmailError() {
    var elem = document.getElementById(element_email_error_id);
    removeAlreadyExistError(elem);
}
function removePasswordError() {
    var elem = document.getElementById(element_password_error_id);
    removeAlreadyExistError(elem);
}
function insertInputErrorBox(parents, errorMsg) {
    var info_t = parents.firstChild;
    removeAlreadyExistError(parents);
    if ('content' in document.createElement('template')) {
        var t = document.querySelector('#login_input_error');
        var clone = document.importNode(t.content, true);
        var errorContainer = clone.querySelector('#error_contents')
        errorContainer.textContent = errorMsg;
        parents.prepend(clone);

        //이벤트 및 타이머 등록하기
        let timerId = setTimeout(function () {
            removeErrorBox(parents);
        }, 5000);
        parents.querySelector(".btn_close").addEventListener('click', function () {
            clearTimeout(timerId);
            removeErrorBox(parents);
        });

    }
    setInputRedBox(parents, true);
}
function removeAlreadyExistError(elem) {
    setInputRedBox(elem, false)
    removeErrorBox(elem);
}
function removeErrorBox(elem) {
    var info_t = elem.querySelector(".info_t");
    if (info_t == undefined) {
        return;
    }
    info_t.remove();
}
function setInputRedBox(elem, active) {
    elem.classList.toggle("error", active);
}
function activeLoginButton(active) {
    document.getElementById("login").classList.toggle("btn_on", active);
}
window.addEventListener("load", function (event) {
    document.getElementById("email").focus();

});

// enter login
// Execute a function when the user releases a key on the keyboard
window.addEventListener("keyup", function (event) {

    if (event.key === 'Escape') {
        event.preventDefault();
        if (!document.getElementById("close").disabled) {
            document.getElementById("close").click();
        }
    } else if (event.key === 'Enter') {
        event.preventDefault();
        if (!document.getElementById("login").disabled) {
            document.getElementById("login").click();
        }
    }
});
