var email, pw, email_container, submit_button;
var alreadyShowEmailError;


function hasClass(element, className)
{
    if (element.classList)
        return element.classList.contains(className);
    return !!element.className.match(new RegExp('(\\s|^)' + className + '(\\s|$)'));
}

function setClass(element, className)
{
    if (element.classList)
        element.classList.add(className)
    else if (!hasClass(element, className))
        element.className += " " + className;
}

function removeClass(element, className)
{
    if (element.classList)
        element.classList.remove(className)
    else if (hasClass(element, className))
    {
        var reg = new RegExp('(\\s|^)' + className + '(\\s|$)');
        element.className = element.className.replace(reg, ' ');
    }
}

function setEnableClass(element, className, enable) {
    if (enable) {
        setClass(element, className)
    } else {
        removeClass(element, className)
    }
}

let timeoutId;
function setEnableEmailError(enable) {
    var className = "error"
    setEnableClass(email_container, className, enable)
    //show and hide valid info
    if (enable && !alreadyShowEmailError) {
        alreadyShowEmailError = true;
        $('.info_t').show();
        timeoutId = setTimeout(function() {
            alreadyShowEmailError = false;
            $('.info_t').hide();
         }, 5000);
    }
    if (enable == false) {
        clearTimeout(timeoutId);
        alreadyShowEmailError = false;
        $('.info_t').hide();
    }
}
function setEnableSumitButton(enable) {
    var className = "btn_on"
    setEnableClass(submit_button, className, enable)
}

/**
 * html element에 관한 컨트롤을 한다.
 */
function elementControl() {
    setEnableSumitButton(email.value.length > 0 && pw.value.length > 0)
}

function onEmailValue() {
    //if (email.value.length > 0 && !checkEmailAndPhoneNumValid(email.value)) {
        //setEnableEmailError(true)
        //return;
    //} else {
        //setEnableEmailError(false)
    //}

    elementControl()
}
function onPasswordValue() {
    elementControl()
}

function checkEmailAndPhoneNumValid(valid) {
    return /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(valid)
        || /\+(9[976]\d|8[987530]\d|6[987]\d|5[90]\d|42\d|3[875]\d|2[98654321]\d|9[8543210]|8[6421]|6[6543210]|5[87654321]|4[987654310]|3[9643210]|2[70]|7|1)\d{1,14}$/.test(valid);
}

function onLoadLoginControl() {
    
    email = document.querySelector("body > div > div > div > div > form > ul > li:nth-child(1) > input[type=email]")
    pw = document.querySelector("body > div > div > div > div > form > ul > li:nth-child(2) > input[type=password]")
    email_container = document.querySelector("body > div > div > div > div > form > ul > li:nth-child(1)")

    email.addEventListener('input', function(event){
        onEmailValue()
    })
    
    pw.addEventListener('input', function(event){
        onPasswordValue()
    })

    submit_button = document.querySelector("body > div > div > div > div > form > div.btn > button")

    submit_button.addEventListener('click', function(event) {
        if (hasClass(submit_button, "btn_on")) {
            document.location = 'hivescheme:login';
        }
    })
}