var okButtonEnable = false;
function setEnableOkButton(enable) {
	okButtonEnable = enable;
	var element = document.querySelector('.btn_confirm');
	if (enable) {
		if (!element.classList.contains('btn_on')) {
			element.classList.remove('btn_off');
			element.classList.add('btn_on');
		}
	} else {
		if (!element.classList.contains('btn_off')) {
			element.classList.remove('btn_on');
			element.classList.add('btn_off');
		}
	}
}

function setPhoneNumber(phoneNumber) {
	document.querySelector('.phone_number').textContent = phoneNumber
}

function getVerificationCode() {
	return document.querySelector('.input_tel').value;
}

function setErrorMessage(msg) {
	console.log(document.querySelector('#code_error'))
	document.querySelector('#code_error').textContent = msg;
	if (!document.querySelector('.input_wrap').classList.contains('error_message')) {
		document.querySelector('.input_wrap').classList.add('error_message')
	}
}

var remainTimeObject;
function setRemainTime(time) {
	if (time <= 0) {
		remainTimeObject.textContent = remain_time_text;
		setErrorMessage(remain_error_text);
		return;
	}
	const m = Math.floor(time / 60)
	const s = Math.floor(time % 60)
	remainTimeObject.textContent = (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s;
}

var timerTime = 0;
var timeId;
var existTimer = false;
function startTimer(time) {
	timerTime = time
	if (existTimer) {
		clearInterval(timeId);
	}
	existTimer = true;
	setRemainTime(time);
	timeId = setInterval(function () {
		timerTime = timerTime - 1;
		setRemainTime(timerTime);
		if (timerTime <= 0) {
			clearInterval(timeId);
			existTimer = false;
		}
	}, 1000);
}

function onOkButton() {
	if (okButtonEnable) {
		location.href = 'hivesdk://ui?button=ok&code=' + getVerificationCode();
	}
}


var resendButtonEnable = false;
function setEnableResend(enable) {
	resendButtonEnable = enable;
	var element = document.querySelector('.btn_resend');
	if (enable) {
		element.classList.remove('btn_off');
	} else {
		if (!element.classList.contains('btn_off')) {
			element.classList.remove('btn_on');
			element.classList.add('btn_off');
		}
	}
}

function onResendButton() {
	if (resendButtonEnable) {
		location.href = 'hivesdk://ui?button=resend';
	}
}
window.addEventListener('load', function () {
	setEnableResend(false);
	setEnableOkButton(false);
	remainTimeObject = document.querySelector('.remain_time');

	document.querySelector('.input_tel').addEventListener('input', function () {
		setEnableOkButton(document.querySelector('.input_tel').value.length > 0);
	})
});