function setCurrentPhoneNumber(phoneNumber) {
	document.querySelector('#current_phone_number').textContent = phoneNumber
}
function setDefaultCountryCode(countryCode) {
	document.querySelector('#country_code').textContent = countryCode;
}
function setCountryCodeList(list, defaultCountryCode) {
	setDefaultCountryCode(defaultCountryCode);
	var ul = document.querySelector('#country_code_list');
	ul.innerHTML = "";
	list.forEach(element => {
		var li = document.createElement('li');
		var btn = document.createElement('button');
		btn.type = "button"
		btn.textContent = element
		li.appendChild(btn);
		ul.appendChild(li);
		li.addEventListener('click', function (event) {
			console.log(event.target)
			setDefaultCountryCode(event.target.textContent)
		});
	});
}
function getCurrentCountryCode() {
	return document.querySelector('#country_code').textContent;
}
function getPhoneNumber() {
	return document.querySelector('#input_phone_number').value;
}

function getVerificationCode() {
	return document.querySelector('#input_code').value;

}
function setPhoneNumberInputErrorMessage(message) {
	if (!document.querySelector('#phone_number_input_error').classList.contains('error_message')) {
		document.querySelector('#phone_number_input_error').classList.add('error_message');
	}
	document.querySelector('#phone_number_input_error_message').textContent = message;
}
function setCodeInputErrorMessage(message) {
	if (!document.querySelector('#code_input_error').classList.contains('error_message')) {
		document.querySelector('#code_input_error').classList.add('error_message');
	}
	document.querySelector('#code_input_error_message').textContent = message;
}

var remainTimeObject;
function setRemainTime(time) {
	if (time <= 0) {
		remainTimeObject.textContent = remain_time_text;
		setCodeInputErrorMessage(remain_error_text);
		return;
	}
	const m = Math.floor(time / 60)
	const s = Math.floor(time % 60)
	remainTimeObject.textContent = (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s;
}

var timerTime = 0;
var timeId;
var existTimer = false;
function startTimer(time) {
	timerTime = time
	if (existTimer) {
		clearInterval(timeId);
	}
	existTimer = true;
	setRemainTime(time);
	timeId = setInterval(function () {
		timerTime = timerTime - 1;
		setRemainTime(timerTime);
		if (timerTime <= 0) {
			clearInterval(timeId);
			existTimer = false;
		}
	}, 1000);
}

var sendButtonEnable = false;
var sendButtonEnableConditionInputField = false;	//	change by javascript keyboard input.
function setEnableSendButton(enable) {
	//	determine by timer.
	sendButtonEnable = enable;
	setEnableSendButtonUI();
}
function setEnableSendButtonUI() {
	//	call by timer or javascript keyboard input.
	var element = document.querySelector('#send_button');
	if (sendButtonEnableConditionInputField && sendButtonEnable) {
		if (!element.classList.contains('btn_on')) {
			element.classList.remove('btn_off');
			element.classList.add('btn_on');
		}
	} else {
		if (!element.classList.contains('btn_off')) {
			element.classList.remove('btn_on');
			element.classList.add('btn_off');
		}
	}
}

var changeButtonEnable = false;
function setEnableChangeButton(enable) {
	changeButtonEnable = enable;
	var element = document.querySelector('#change_button');
	if (enable) {
		if (!element.classList.contains('btn_on')) {
			element.classList.remove('btn_off');
			element.classList.add('btn_on');
		}
	} else {
		if (!element.classList.contains('btn_off')) {
			element.classList.remove('btn_on');
			element.classList.add('btn_off');
		}
	}
}

function changeButtonEnableValidator() {
	var enableFlag = document.querySelector('#input_code').value.length > 0;
	enableFlag = enableFlag && document.querySelector('#agree_1').checked;
	setEnableChangeButton(enableFlag);
}

function onSendButton() {
	if (sendButtonEnable) {
		location.href = 'hivesdk://ui?button=send&country_code=' + getCurrentCountryCode() + '&phone_number=' + getPhoneNumber();
	}
}

function onChangeButton() {
	if (changeButtonEnable) {
		location.href = 'hivesdk://ui?button=ok&code=' + getVerificationCode();
	}
}

function updateSendButton() {
	sendButtonEnableConditionInputField = document.querySelector('#input_phone_number').value.length > 0;
	setEnableSendButtonUI();
}

// 코드 재전송 버튼 프리즈하기
var codeSendFreeze = false;
function setCodeSendFreeze(freeze) {
	codeSendFreeze = freeze;
	updateSendButton();
}

window.addEventListener('load', function () {
	setEnableSendButton(false);
	setEnableChangeButton(false);

	updateSendButton();
	remainTimeObject = document.querySelector(".remain_time");
	document.querySelector('#input_phone_number').addEventListener('input', function () {
		updateSendButton();
	});

	document.querySelector('#agree_1').addEventListener('input', function () {
		changeButtonEnableValidator();
	});
	document.querySelector('#input_code').addEventListener('input', function () {
		changeButtonEnableValidator();
	});
});
