// 다국어
const language_table = {
    ko: {
        0: "페이지를 표시할 수 없습니다.",
        1: "잠시 후 다시 시도해주세요.",
        2: "재시도"
    },
    en: {
        0: "Failed to load the page.",
        1: "Please try again later.",
        2: "Retry"
    },
    ja: {
        0: "ページを表示できません。",
        1: "暫くして再度お試しください。",
        2: "リトライ"
    },
    ru: {
        0: "Не удалось загрузить страницу.",
        1: "Пожалуйста, повторите попытку позже.",
        2: "Заново"
    },
    fr: {
        0: "Erreur de chargement de la page.",
        1: "Réessaie plus tard.",
        2: "Réessayer"
    },
    de: {
        0: "Fehler beim Laden der Seite.",
        1: "Bitte versuche es später erneut.",
        2: "Wiederholen"
    },
    es: {
        0: "Error al cargar la página.",
        1: "Por favor inténtelo de nuevo más tarde.",
        2: "Reintentar"
    },
    pt: {
        0: "Erro ao carregar a página.",
        1: "Por favor tente novamente depois.",
        2: "Tentar Novamente"
    },
    in: {
        0: "Gagal memuat halaman.",
        1: "Harap coba lagi nanti.",
        2: "Coba Lagi"
    },
    ms: {
        0: "Gagal untuk memuatkan halaman.",
        1: "Sila cuba semula kemudian.",
        2: "Cuba Lagi"
    },
    th: {
        0: "ไม่สามารถโหลดหน้านี้ได้",
        1: "กรุณาลองใหม่ภายหลัง",
        2: "ลองใหม่"
    },
    vi: {
        0: "Tải trang thất bại.",
        1: "Vui lòng thử lại sau.",
        2: "Thử lại"
    },
    it: {
        0: "Non è possibile visualizzare la pagina.",
        1: "Riprova più tardi.",
        2: "Riprova"
    },
    tr: {
        0: "Sayfa görüntülünemiyor.",
        1: "Lütfen sonra tekrar dene.",
        2: "Tekrarla"
    },
    ar: {
        0: "أخفق تحميل الصفحة.",
        1: "الرجاء معاودة المحاولة في وقت لاحق.",
        2: "إعادة المحاولة"
    },
    "zh-hans": {
        0: "无法显示页面",
        1: "请稍后再试",
        2: "再试一次"
    },
    "zh-hant": {
        0: "頁面無法顯示",
        1: "請稍後再次嘗試",
        2: "再試一次"
    }
};

// Function to retrieve language content based on the current language code
function setLanguage(langCode) {
    return language_table[langCode] || language_table.en;
}
function updateLanguage() {
	var c = document.documentElement.lang;
	var lang = setLanguage(c);
	pagenot.innerHTML = lang[0];
	tryagain.innerHTML = lang[1];
  	retry.innerHTML = lang[2];
	console.log(c);
}
function getParameterByName(name, url) {
    if (!url) url = window.location.href;
    name = name.replace(/[\[\]]/g, "\\$&");
    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, " "));
}
function onRetry() {
	const tabPane = window.parent.document.querySelector('div.tab-pane.active.show');
	const tabSuffix = tabPane ? tabPane.id.split('-')[1] : "";
	window.location = `hivepromotion://retry${tabSuffix ? `?tab=${tabSuffix}` : ""}`;
}