function initUI(code, url, time) {
    updateUserCode(code);
    updateUrl(url);
    updateTime(time);
}
function updateUserCode(code) {
    var div = document.querySelector('div.code_num > div') //Code tag
    div.innerHTML = '';
    for (var i = 0; i < code.length; i++) {
        var span = document.createElement("span");
        span.textContent = code[i];
        div.appendChild(span);
    }
}
function updateUrl(url) {
    const urlHype = document.querySelector('div.code_wrap > div.content > span');
    urlHype.textContent = url; //Url tag
    const qrdiv = document.querySelector("div.code_wrap > div.thumb")
    qrdiv.innerHTML = "";
    new QRCode(qrdiv, url); //QRcode tag
}
function secondsToHHMM(seconds) {
    const minutes = Math.floor(seconds / 60);
    const remainingSeconds = seconds % 60;

    const formattedMinutes = minutes.toString().padStart(2, '0');
    const formattedSeconds = remainingSeconds.toString().padStart(2, '0');

    return `${timeout_description} ${formattedMinutes}:${formattedSeconds}`;
}

let interval; // 타이머를 저장하기 위한 변수
function startTimer(initialSeconds) {
    let currentSeconds = initialSeconds;

    const timerElement = document.querySelector('div.code_text > span.count'); //Timer tag
    timerElement.textContent = secondsToHHMM(currentSeconds);

    clearInterval(interval); // 이전 타이머가 있다면 중지

    interval = setInterval(() => {
        if (currentSeconds <= 0) {
            clearInterval(interval);
            return; // 시간이 0이면 타이머 중지
        }
        currentSeconds--;
        timerElement.textContent = secondsToHHMM(currentSeconds);
    }, 1000);
}

function updateTime(time) {
    startTimer(time);
}
function showError() {
    var errorElements = $('.error'); //Error tag
    errorElements.show()
    errorElements.each(function () {
        var errorElement = $(this);
        setTimeout(function () {
            errorElement.hide();
        }, 5000);
    });
}