// Copyright 1998-2017 Epic Games, Inc. All Rights Reserved.

#include "HIVEConfigEditor.h"

#include "SlateBasics.h"

// Settings
#include "ISettingsModule.h"
#include "HIVEConfigAndroidSettings.h"
#include "HIVEConfigIOSSettings.h"
#include "HIVEConfigWindowsSettings.h"


#define LOCTEXT_NAMESPACE "FHIVEConfigEditor"

void FHIVEConfigEditor::StartupModule()
{
	// This code will execute after your module is loaded into memory; the exact timing is specified in the .uplugin file per-module
    
    if (ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings"))
    {
        SettingsModule->RegisterSettings("Project", "Hive Config", "Android",
                                         LOCTEXT("HiveConfigEditorAndroidDisplayName", "Android"),
                                         LOCTEXT("HiveConfigEditorAndroidDescription", "Create Config file(hive_config.xml)"),
                                         GetMutableDefault<UHIVEConfigAndroidSettings>());

        SettingsModule->RegisterSettings("Project", "Hive Config", "iOS",
                                         LOCTEXT("HiveConfigEditorIOSDisplayName", "iOS"),
                                         LOCTEXT("HiveConfigEditorIOSDescription", "Create Config file(hive_config.xml)"),
                                         GetMutableDefault<UHIVEConfigIOSSettings>());

        SettingsModule->RegisterSettings("Project", "Hive Config", "Windows",
                                         LOCTEXT("HiveConfigEditorWindowsDisplayName", "Windows"),
                                         LOCTEXT("HiveConfigEditorWindowsDescription", "Create Config file(hive_config.xml)"),
                                         GetMutableDefault<UHIVEConfigWindowsSettings>());
    }
}

void FHIVEConfigEditor::ShutdownModule()
{
	// This function may be called during shutdown to clean up your module.  For modules that support dynamic reloading,
	// we call this function before unloading the module.
    
    ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");
    
    if (SettingsModule != nullptr)
    {
        SettingsModule->UnregisterSettings("Project", "Hive Config", "Android");
        SettingsModule->UnregisterSettings("Project", "Hive Config", "iOS");
        SettingsModule->UnregisterSettings("Project", "Hive Config", "Windows");
    }
}

#undef LOCTEXT_NAMESPACE
	
IMPLEMENT_MODULE(FHIVEConfigEditor, HIVEConfigEditor)
