// Copyright (C) 2024 Com2uS Platform Corporation

#include "HIVEConfigIOSSettings.h"


UHIVEConfigIOSSettings::UHIVEConfigIOSSettings(const FObjectInitializer& ObjectInitializer)
: Super(ObjectInitializer)
, SaveAnalyticsLogBeforeCrash(false)
{
    ConfigFilePath = TEXT("Plugins/HIVESDK/Source/HiveSDKiOS/resource/hive_config.xml");
}

void UHIVEConfigIOSSettings::PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent)
{
    Super::PostEditChangeProperty(PropertyChangedEvent);

    if(ConfigFilePath.IsEmpty())
    {
        UE_LOG(LogTemp, Log, TEXT("UHIVEConfigBaseSettings PostEditChangeProperty ConfigPath Is Empty."));
        return;
    }

    FString absoluteConfigPath = FPaths::Combine(*FPaths::ProjectDir(), *ConfigFilePath); 
    ConfigFile.LoadFile(TCHAR_TO_UTF8(*absoluteConfigPath));
    
    if(ConfigFile.NoChildren())
        ConfigFile.Parse(GetBaseXmlChar());
    
    RootNode = ConfigFile.RootElement();


    const FName PropertyName = (PropertyChangedEvent.Property != NULL) ? PropertyChangedEvent.Property->GetFName() : NAME_None;

    if (PropertyName == GET_MEMBER_NAME_CHECKED(UHIVEConfigIOSSettings, SaveAnalyticsLogBeforeCrash))
    {
        FString sSaveAnalyticsLogBeforeCrash = SaveAnalyticsLogBeforeCrash ? TEXT("true") : TEXT("false");
        AddOrReplaceElement(TEXT("saveAnalyticsLogBeforeCrash"), sSaveAnalyticsLogBeforeCrash);
    }

    ConfigFile.SaveFile(TCHAR_TO_UTF8(*absoluteConfigPath));
}