// Copyright (C) 2024 Com2uS Platform Corporation

#pragma once

#include "CoreMinimal.h"

#include "HIVEConfigCommonSettings.h"

#include "HIVEConfigAndroidSettings.generated.h"

USTRUCT()
struct FHIVEConfigProviderGooglePlayGames
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ServerClientId;
};

UCLASS(config=Engine, defaultconfig)
class UHIVEConfigAndroidSettings : public UHIVEConfigCommonSettings
{
    GENERATED_UCLASS_BODY()
public:
    UPROPERTY(Config, EditAnywhere, Category = "Android", Meta = (DisplayName = "UnsupportedUAShareType"))
    TArray<FString> UnsupportedUAShareTypeValues;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "GooglePlayGames"))
    FHIVEConfigProviderGooglePlayGames ProviderGooglePlayGames;

    void PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent);
    
private:
    tinyxml2::XMLNode* SerachXMLAttribute(tinyxml2::XMLNode *targetNode, const char* attributeName, const char* attributeValue);
    void SetFacebookAndroidManifestOptions();
    void SetAirbridgeOptions();
    void SetGooglePlayGamesAndroidManifestOptions();
    void SetQQManifestOptions();
    void SetVKManifestOptions();
};
