// Copyright (C) 2024 Com2uS Platform Corporation

#pragma once

#include "tinyxml2.h" // XML file Header

#include "CoreMinimal.h"
#include "HIVEConfigCommonSettings.generated.h"

UENUM()
enum class EHIVEConfigZone : uint8
{
    /** Sandbox Server */
    Sandbox = 0,
    
    /** Real Server */
    Real = 1
};

UENUM()
enum class EHIVEConfigOrientation : uint8
{
    Undefined = 0,
    All = 1,
    Portrait = 2,
    Landscape = 3
};

UENUM()
enum class EHIVEConfigAgreementDetermineBase : uint8
{
    Device = 0,
    Account = 1
};

USTRUCT()
struct FHIVEConfigProviderFacebook
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ClientToken;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<FString> Permissions;
};

USTRUCT()
struct FHIVEConfigProviderGoogle
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ServerClientId;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ClientId;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ReverseClientId;
};

USTRUCT()
struct FHIVEConfigProviderWechat
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Secret;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString PaymentKey;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString UniversalLink;
};

USTRUCT()
struct FHIVEConfigProviderQQ
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;
};

USTRUCT()
struct FHIVEConfigProviderVK
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString AppId;
};

USTRUCT()
struct FHIVEConfigProviderLine
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ChannelID;
};

USTRUCT()
struct FHIVEConfigProviderWeverse
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ClientID;
};

USTRUCT()
struct FHIVEConfigProviderSignInWithApple
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ServiceID;
};

USTRUCT()
struct FHIVEConfigProviderTelegram
{
    GENERATED_USTRUCT_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Attribute")
    FString BotID;

    UPROPERTY(config, EditAnywhere, Category = "Attribute")
    FString BotDomain;
};

USTRUCT()
struct FHIVEConfigProviderSteam
{
    GENERATED_USTRUCT_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Attribute")
    FString Realm;
};

USTRUCT()
struct FHIVEConfigProviderX
{
    GENERATED_USTRUCT_BODY()

    UPROPERTY(config, EditAnywhere, Category = "Attribute")
    FString ClientId;
};

USTRUCT()
struct FHIVEConfigEvent
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString EventName;
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString EventValue;
};

USTRUCT()
struct FHIVEConfigProviderAdjust
{
    GENERATED_USTRUCT_BODY()

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Key;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<struct FHIVEConfigEvent> Events;
};

USTRUCT()
struct FHIVEConfigProviderSingular
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Key;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<struct FHIVEConfigEvent> Events;
};

USTRUCT()
struct FHIVEConfigProviderAppsFlyer
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Key;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ItunesConnectAppId;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<struct FHIVEConfigEvent> Events;
};

USTRUCT()
struct FHIVEConfigProviderFirebase
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Key;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<struct FHIVEConfigEvent> Events;
};

USTRUCT()
struct FHIVEConfigProviderAirbridge
{
    GENERATED_USTRUCT_BODY()
    
    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString ID;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Key;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString AppName;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString SecretId;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    FString Secret;

    UPROPERTY(config, EditAnywhere, Category="Attribute")
    TArray<struct FHIVEConfigEvent> Events;
};


UCLASS(config=Engine, defaultconfig)
class UHIVEConfigCommonSettings : public UObject
{
    GENERATED_UCLASS_BODY()
    
public:
    /* Common */
    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "App ID"))
    FString AppId;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "Zone"))
    EHIVEConfigZone Zone;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "UseLog"))
    bool UseLog;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "AgeGateU13"))
    bool AgeGateU13;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "Company"))
    FString Company;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "Channel"))
    FString Channel;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "Market"))
    FString Market;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "UI Orientation"))
    EHIVEConfigOrientation Orientation;

    UPROPERTY(Config, EditAnywhere, Category = "Common", Meta = (DisplayName = "AgreementDetermineBase"))
    EHIVEConfigAgreementDetermineBase AgreementDetermineBase;

    /* Common - Advance */
    UPROPERTY(Config, EditAnywhere, Category = "Common|Common Advance Settings", Meta = (DisplayName = "HttpConnectTimeout"))
    FString HttpConnectTimeout;

    UPROPERTY(Config, EditAnywhere, Category = "Common|Common Advance Settings", Meta = (DisplayName = "HttpReadTimeout"))
    FString HttpReadTimeout;

    /* Common - Provider */
    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Facebook"))
    FHIVEConfigProviderFacebook ProviderFacebook;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Google"))
    FHIVEConfigProviderGoogle ProviderGoogle;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Wechat"))
    FHIVEConfigProviderWechat ProviderWechat;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "QQ"))
    FHIVEConfigProviderQQ ProviderQQ;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "VK"))
    FHIVEConfigProviderVK ProviderVK;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Line"))
    FHIVEConfigProviderLine ProviderLine;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Weverse"))
    FHIVEConfigProviderWeverse ProviderWeverse;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "SignInWithApple"))
    FHIVEConfigProviderSignInWithApple ProviderSignInWithApple;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Telegram"))
    FHIVEConfigProviderTelegram ProviderTelegram;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "Steam"))
    FHIVEConfigProviderSteam ProviderSteam;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|AuthV4", Meta = (DisplayName = "X"))
    FHIVEConfigProviderX ProviderX;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|Attribute", Meta = (DisplayName = "Adjust"))
    FHIVEConfigProviderAdjust ProviderAdjust;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|Attribute", Meta = (DisplayName = "Singular"))
    FHIVEConfigProviderSingular ProviderSingular;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|Attribute", Meta = (DisplayName = "AppsFlyer"))
    FHIVEConfigProviderAppsFlyer ProviderAppsFlyer;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|Attribute", Meta = (DisplayName = "Firebase"))
    FHIVEConfigProviderFirebase ProviderFirebase;

    UPROPERTY(Config, EditAnywhere, Category = "Provider|Attribute", Meta = (DisplayName = "Airbridge"))
    FHIVEConfigProviderAirbridge ProviderAirbridge;

    void PostEditChangeProperty(struct FPropertyChangedEvent& PropertyChangedEvent);

protected:
    tinyxml2::XMLDocument ConfigFile;
    tinyxml2::XMLElement *RootNode;
    FString ConfigFilePath;

    const char* GetBaseXmlChar();
    void AddOrReplaceElement(FString key, FString value);
    void AddOrReplaceInProviders(tinyxml2::XMLElement* Provider);
};
