#if PLATFORM_WINDOWS //UE
#include "CEFTextInputMethodContext.h"
#include "IMEProcess.h"
#include "Windows/WindowsHWrapper.h"
#include <string>

extern LPFN_SET_IME_PROCESS lpfnSetImeProcess;

FCEFTextInputMethodContext::FCEFTextInputMethodContext()
	: bIsComposing(false)
	, CompositionBeginIndex(0)
	, CompositionLength(0)
	, SelectionRangeBeginIndex(0)
	, SelectionRangeLength(0)
	, SelectionCaretPosition(ECaretPosition::Ending)
	, bIsEnable(false)
{
}

FCEFTextInputMethodContext::~FCEFTextInputMethodContext() {

	::OutputDebugString(L"FCEFTextInputMethodContext destroy\n");
}

void FCEFTextInputMethodContext::Enable()
{
	if (bIsEnable) {
		return;
	}

	FSlateApplication::Get().GetTextInputMethodSystem()->RegisterContext(AsShared());
	FSlateApplication::Get().GetTextInputMethodSystem()->ActivateContext(AsShared());

	bIsEnable = true;
}

void FCEFTextInputMethodContext::Disable()
{
	if (!bIsEnable) {
		return;
	}

	/*if (lpfnSetImeProcess != nullptr) {

		lpfnSetImeProcess(IME_MODE::ImeCefSetFocus, nullptr, nullptr, nullptr);
	}*/
	
	FSlateApplication::Get().GetTextInputMethodSystem()->DeactivateContext(AsShared());
	FSlateApplication::Get().GetTextInputMethodSystem()->UnregisterContext(AsShared());

	bIsEnable = false;
}

void FCEFTextInputMethodContext::AbortComposition()
{
	bIsComposing = false;
	//Owner->InternalCefBrowser->GetHost()->ImeCancelComposition();
	
	if (lpfnSetImeProcess != nullptr) {

		lpfnSetImeProcess(IME_MODE::ImeCancelComposition, nullptr, nullptr, nullptr);
	}

	ResetComposition();
}

bool FCEFTextInputMethodContext::UpdateCachedGeometry(const FGeometry& AllottedGeometry)
{
	bool bCachedGeometryUpdated = false;
	/*if (CachedGeometry != AllottedGeometry)
	{
		CachedGeometry = AllottedGeometry;
		bCachedGeometryUpdated = true;
	}*/

	return bCachedGeometryUpdated;
}

bool FCEFTextInputMethodContext::CEFCompositionRangeChanged(void* SelectionRange, const std::vector<INPUT_RECT>& CharacterBounds)
{
	/*if (bIsComposing)
	{
		if (CharacterBounds != CefCompositionBounds)
		{
			CefCompositionBounds = CharacterBounds;
			return true;
		}
	}*/
	return false;
}

bool FCEFTextInputMethodContext::IsComposing()
{
	return bIsComposing;
}

bool FCEFTextInputMethodContext::IsReadOnly()
{
	return false;
}

uint32 FCEFTextInputMethodContext::GetTextLength()
{
	return CompositionString.Len();
}

void FCEFTextInputMethodContext::GetSelectionRange(uint32& BeginIndex, uint32& Length, ECaretPosition& CaretPosition)
{
	BeginIndex = SelectionRangeBeginIndex;
	Length = SelectionRangeLength;
	CaretPosition = SelectionCaretPosition;
}

void FCEFTextInputMethodContext::SetSelectionRange(const uint32 BeginIndex, const uint32 Length, const ECaretPosition CaretPosition)
{
	SelectionRangeBeginIndex = BeginIndex;
	SelectionRangeLength = Length;
	SelectionCaretPosition = CaretPosition;

	/*CefString Str = TCHAR_TO_WCHAR(*CompositionString);
	std::vector<CefCompositionUnderline> underlines;
	Owner->InternalCefBrowser->GetHost()->ImeSetComposition(
		Str,
		underlines,
		CefRange(UINT32_MAX, UINT32_MAX),
		CefRange(SelectionRangeBeginIndex, SelectionRangeLength));*/
	
	if (lpfnSetImeProcess != nullptr) {

		std::wstring str = std::wstring(*CompositionString);
		void* data1 = &str;
		void* data2 = &SelectionRangeBeginIndex;
		void* data3 = &SelectionRangeLength;

		lpfnSetImeProcess(IME_MODE::ImeSetComposition, data1, data2, data3);
	}
}

void FCEFTextInputMethodContext::GetTextInRange(const uint32 BeginIndex, const uint32 Length, FString& OutString)
{
	OutString = CompositionString.Mid(BeginIndex, Length);
}

void FCEFTextInputMethodContext::SetTextInRange(const uint32 BeginIndex, const uint32 Length, const FString& InString)
{
	FString NewString;
	if (BeginIndex > 0)
	{
		NewString = CompositionString.Mid(0, BeginIndex);
	}

	NewString += InString;

	if ((int32)(BeginIndex + Length) < CompositionString.Len())
	{
		NewString += CompositionString.Mid(BeginIndex + Length, CompositionString.Len() - (BeginIndex + Length));
	}
	CompositionString = NewString;

	/*CefString Str = TCHAR_TO_WCHAR(*CompositionString);
	std::vector<CefCompositionUnderline> underlines;
	Owner->InternalCefBrowser->GetHost()->ImeSetComposition(
		Str,
		underlines,
		CefRange(UINT32_MAX, UINT32_MAX),
		CefRange(0, Str.length()));*/

	std::wstring str = std::wstring(*CompositionString);
	void* data1 = &str;

	if (lpfnSetImeProcess != nullptr) {

		lpfnSetImeProcess(IME_MODE::ImeSetComposition, data1, nullptr, nullptr);
	}
}

bool Contains(const INPUT_RECT& rect, int point_x, int point_y) {
	return (point_x >= rect.left) && (point_x < rect.right) && (point_y >= rect.top) &&
		(point_y < rect.bottom);
}

bool Contains(const INPUT_RECT& rect, const INPUT_POINT& point) {
	return Contains(rect, point.x, point.y);
}

int32 FCEFTextInputMethodContext::GetCharacterIndexFromPoint(const FVector2D& Point)
{
	int32 ResultIdx = INDEX_NONE;

	/*const FVector2D LocalPoint = CachedGeometry.AbsoluteToLocal(Point);
	INPUT_POINT CefLocalPoint = { FMath::RoundToInt(LocalPoint.X), FMath::RoundToInt(LocalPoint.Y) };

	for (uint32 CharIdx = 0; CharIdx < CefCompositionBounds.size(); CharIdx++)
	{
		if (Contains(CefCompositionBounds[CharIdx], CefLocalPoint))
		{
			ResultIdx = CharIdx;
			break;
		}
	}*/
	return ResultIdx;
}

bool FCEFTextInputMethodContext::GetTextBounds(const uint32 BeginIndex, const uint32 Length, FVector2D& Position, FVector2D& Size)
{
	Position = { GSystemResolution.ResX / 2.0f, GSystemResolution.ResY / 2.0f };
	Size = FVector2D::ZeroVector;
	//if (CefCompositionBounds.size() < BeginIndex ||
	//	CefCompositionBounds.size() < BeginIndex + Length)
	//{
	//	if (CefCompositionBounds.size() > 0)
	//	{
	//		// Fall back to the start of the composition
	//		Position = CachedGeometry.LocalToAbsolute(FVector2D(CefCompositionBounds[0].left, CefCompositionBounds[0].top));
	//		Size = FVector2D(CefCompositionBounds[0].right - CefCompositionBounds[0].left,
	//			CefCompositionBounds[0].bottom - CefCompositionBounds[0].top);
	//		return false;
	//	}
	//	else
	//	{
	//		// We  don't have any updated composition bounds so we'll just default to the window bounds and say we are clipped.
	//		GetScreenBounds(Position, Size);
	//		return true;
	//	}
	//}

	//FVector2D LocalSpaceMin(FLT_MAX, FLT_MAX);
	//FVector2D LocalSpaceMax(-FLT_MAX, -FLT_MAX);

	//for (uint32 CharIdx = BeginIndex; CharIdx < BeginIndex + Length; CharIdx++)
	//{
	//	if (LocalSpaceMin.X > CefCompositionBounds[CharIdx].left)
	//	{
	//		LocalSpaceMin.X = CefCompositionBounds[CharIdx].left;
	//	}

	//	if (LocalSpaceMax.X < CefCompositionBounds[CharIdx].right)
	//	{
	//		LocalSpaceMax.X = CefCompositionBounds[CharIdx].right;
	//	}

	//	if (LocalSpaceMin.Y > CefCompositionBounds[CharIdx].top)
	//	{
	//		LocalSpaceMin.Y = CefCompositionBounds[CharIdx].top;
	//	}

	//	if (LocalSpaceMax.Y < CefCompositionBounds[CharIdx].bottom)
	//	{
	//		LocalSpaceMax.Y = CefCompositionBounds[CharIdx].bottom;
	//	}
	//}

	//Position = CachedGeometry.LocalToAbsolute(LocalSpaceMin);
	//Size = LocalSpaceMax - LocalSpaceMin;

	return false; // false means "not clipped"
}

void FCEFTextInputMethodContext::GetScreenBounds(FVector2D& Position, FVector2D& Size)
{
	Position = { GSystemResolution.ResX / 2.0f, GSystemResolution.ResY / 2.0f };
	Size = FVector2D::ZeroVector;
	/*Position = CachedGeometry.GetAccumulatedRenderTransform().GetTranslation();
	Size = TransformVector(CachedGeometry.GetAccumulatedRenderTransform(), CachedGeometry.GetLocalSize());*/
}

TSharedPtr<FGenericWindow> FCEFTextInputMethodContext::GetWindow()
{
	TSharedPtr<SWidget> wid = FSlateApplication::Get().GetKeyboardFocusedWidget();
	TSharedPtr<SWindow> win = FSlateApplication::Get().FindWidgetWindow(wid.ToSharedRef());
	return win->GetNativeWindow();
}

void FCEFTextInputMethodContext::BeginComposition()
{
	if (!bIsComposing)
	{
		bIsComposing = true;
	}
}

void FCEFTextInputMethodContext::UpdateCompositionRange(const int32 InBeginIndex, const uint32 InLength)
{
	CompositionBeginIndex = InBeginIndex;
	CompositionLength = InLength;
}

void FCEFTextInputMethodContext::EndComposition()
{
	if (bIsComposing)
	{
		bIsComposing = false;

		if (CompositionString.Len() > 0)
		{
			/*CefString Result = TCHAR_TO_WCHAR(*CompositionString);
			Owner->InternalCefBrowser->GetHost()->ImeCommitText(Result, CefRange(UINT32_MAX, UINT32_MAX), 0);*/
			if (lpfnSetImeProcess != nullptr) {

				std::wstring str = std::wstring(*CompositionString);
				void* data1 = &str;

				lpfnSetImeProcess(IME_MODE::ImeCommitText, data1, nullptr, nullptr);
			}
		}
		else
		{
			//Owner->InternalCefBrowser->GetHost()->ImeCancelComposition();
			if (lpfnSetImeProcess != nullptr) {
			
				lpfnSetImeProcess(IME_MODE::ImeCancelComposition, nullptr, nullptr, nullptr);
			}
		}
		ResetComposition();
	}
}

void FCEFTextInputMethodContext::ResetComposition()
{
	CompositionString.Empty();
	CefCompositionBounds.clear();
	CompositionBeginIndex = 0;
	CompositionLength = 0;

	SelectionRangeBeginIndex = 0;
	SelectionRangeLength = 0;
}
#else

#endif

