

#include "CPP/HIVE_CppPlugin.h"


#include <string.h>
#include <string>

#if defined(ANDROID) || defined(__ANDROID__) || PLATFORM_ANDROID
#include <jni.h>
#include <android/log.h>
#include <pthread.h>
#endif		// #if !defined(__OBJC__)
#if defined(ANDROID) || defined(__ANDROID__) || PLATFORM_ANDROID || (!WITH_EDITOR && (PLATFORM_MAC || PLATFORM_WINDOWS))
#if defined(ANDROID) || defined(__ANDROID__) || PLATFORM_ANDROID
extern std::string HiveCPP_CallNative(std::string jsonParamString);
#endif
NS_HIVE_BEGIN
#if defined(ANDROID) || defined(__ANDROID__) || PLATFORM_ANDROID
picojson::value HiveCppPlugin::callNative(std::string jsonParam) {
    std::string jsonParamString = jsonParam;
    std::string resJsonString = ::HiveCPP_CallNative(jsonParamString);

    picojson::value resJson;
    std::string err = picojson::parse(resJson, resJsonString);
    return resJson;
}
#endif
//TODO String Util 만들지.. 생각해봐야할듯 gnustl 에서 이상하게 std::to_string이 빠져있음.
//template <typename T>
std::string to_string(const long long value)
{
    //    std::ostringstream os ;
    char buf[100] = {0,};
    snprintf(buf, sizeof(buf), "%lld", value);

    return buf;
}

std::string to_string(const int value)
{
    char buf[100] = {0,};
    snprintf(buf, sizeof(buf), "%d", value);
    
    return buf;
}

std::string to_string(const double value)
{
    char buf[100] = {0,};
    snprintf(buf, sizeof(buf), "%f", value);
    
    return buf;
}

picojson::object HiveCppPlugin::createParam(std::string className, std::string methodName)
{
	picojson::object jsonParam;
	jsonParam["class"] = (picojson::value)className;
	jsonParam["method"] = (picojson::value)methodName;
	jsonParam["platform"] = (picojson::value)"cpp";
	return jsonParam;
}

picojson::value HiveCppPlugin::callNative(picojson::object jsonParam)
{
	std::string jsonParamString = picojson::value(jsonParam).serialize();
    return callNative(jsonParamString);
}

void HiveCppPlugin::callEngine(std::string jsonParamString)
{
    picojson::value jsonParam;
    std::string err = picojson::parse(jsonParam, jsonParamString);
    if(!err.empty())
    {
    	//return;
    }

    std::string className = jsonParam.get("class").to_str();
    std::string methodName = jsonParam.get("method").to_str();

    if(className.compare("Analytics") == 0)
    {
    	NS_HIVE::Analytics::executeEngine(jsonParam);
    }
    else if (className.compare("AuthV4") == 0)
    {
        NS_HIVE::AuthV4::executeEngine(jsonParam);
    }
    else if (className.compare("AuthV4Helper") == 0)
    {
        NS_HIVE::AuthV4::Helper::executeEngine(jsonParam);
    }
    else if (className.compare("Chat") == 0)
    {
        NS_HIVE::Chat::executeEngine(jsonParam);
    }
    else if(className.compare("Configuration") == 0)
    {
    	NS_HIVE::Configuration::executeEngine(jsonParam);
    }
    else if (className.compare("DataStore") == 0)
    {
        NS_HIVE::DataStore::executeEngine(jsonParam);
    }
    else if (className.compare("IAPV4") == 0)
    {
        NS_HIVE::IAPV4::executeEngine(jsonParam);
    }
    else if (className.compare("MatchMaking") == 0)
    {
        NS_HIVE::MatchMaking::executeEngine(jsonParam);
    }
    else if (className.compare("PlatformHelper") == 0)
    {
        NS_HIVE::PlatformHelper::executeEngine(jsonParam);
    }
    else if(className.compare("Promotion") == 0)
    {
    	NS_HIVE::Promotion::executeEngine(jsonParam);
    }
    else if (className.compare("ProviderApple") == 0)
    {
        NS_HIVE::ProviderApple::executeEngine(jsonParam);
    }
    else if (className.compare("ProviderGoogle") == 0)
    {
        NS_HIVE::ProviderGoogle::executeEngine(jsonParam);
    }
    else if(className.compare("Push") == 0)
    {
    	NS_HIVE::Push::executeEngine(jsonParam);
    }
    else if(className.compare("SocialV4") == 0)
    {
        NS_HIVE::SocialV4::executeEngine(jsonParam);
    }
}

NS_HIVE_END		// namespace hive

#endif //   #if defined(ANDROID) || defined(__ANDROID__) || PLATFORM_ANDROID || (!WITH_EDITOR && (PLATFORM_MAC || PLATFORM_WINDOWS))



#if defined(CC_TARGET_OS_IPHONE) || PLATFORM_IOS
#endif      // #if defined(__OBJC__)


#if defined(CC_TARGET_OS_ANDROID)
#elif PLATFORM_ANDROID //UnrealEgine

#include "Runtime/Launch/Public/Android/AndroidJNI.h"
#include "Android/AndroidApplication.h"

extern JavaVM* GJavaVM;

extern "C" {

    JNIEXPORT void JNICALL Java_com_hive_plugin_HivePluginUnreal_jniCallEngine(JNIEnv *env, jobject jobj, jstring target, jstring jsonParamJString)
    {
        std::string jsonParamString = (char*)env->GetStringUTFChars(jsonParamJString, NULL);
        NS_HIVE::HiveCppPlugin::callEngine(jsonParamString);
    }
    
}		// extern "C" {


std::string HiveCPP_CallNative(std::string jsonParamString)
{
    jclass cls;
    jmethodID methodId;
    
    JNIEnv* g_jniEnv = NULL;
    GJavaVM->GetEnv((void **)&g_jniEnv, JNI_VERSION_1_6);
    cls = FAndroidApplication::FindJavaClass("com/hive/plugin/HivePluginUnreal");
    if (g_jniEnv->ExceptionCheck())
    {
        jthrowable exception = g_jniEnv->ExceptionOccurred();
        g_jniEnv->ExceptionDescribe();
        g_jniEnv->ExceptionClear();
        g_jniEnv->DeleteLocalRef(exception);
        return "";
    }
    
    methodId = g_jniEnv->GetStaticMethodID(cls, "callNativeApi", "(Ljava/lang/String;)Ljava/lang/String;");
    if (g_jniEnv->ExceptionCheck())
    {
        jthrowable exception = g_jniEnv->ExceptionOccurred();
        g_jniEnv->ExceptionClear();
        g_jniEnv->DeleteLocalRef(exception);
        
        return "";
    }
    
    

    jstring stringArg = g_jniEnv->NewStringUTF((char*)jsonParamString.c_str());
    jstring resJsonJString = (jstring)g_jniEnv->CallStaticObjectMethod(cls, methodId, stringArg);
    
    g_jniEnv->DeleteLocalRef(cls);
    
    
    const char *nativeResult = g_jniEnv->GetStringUTFChars(resJsonJString, 0);
    
    FString resultJsonString = FString(nativeResult);

    std::string resJsonString = (char*)g_jniEnv->GetStringUTFChars(resJsonJString, NULL);
    g_jniEnv->DeleteLocalRef(resJsonJString);
    
    return resJsonString;
    
}
#endif

#if !WITH_EDITOR && (PLATFORM_MAC || PLATFORM_WINDOWS)
#include <mutex>    //  std call_once
extern "C" char* HiveCPP_CallNative(const char* jsonParamString);
extern "C" void STDCALL SetHiveSendMessageCallback(void (STDCALL* callback)(const char* message));

NS_HIVE_BEGIN
void callEngineUnreal(const char* jsonParamStringChar);
std::once_flag set_UE_callback_once_flag;

picojson::value HiveCppPlugin::callNative(std::string jsonParam) {
    std::call_once(set_UE_callback_once_flag, []() {
        SetHiveSendMessageCallback(callEngineUnreal);
        });

    std::string jsonParamString = jsonParam;
    std::string resJsonString = ::HiveCPP_CallNative(jsonParamString.c_str());

    picojson::value resJson;
    std::string err = picojson::parse(resJson, resJsonString);
    return resJson;
}
// == HiveCppPlugin::callEngine
void callEngineUnreal(const char* jsonParamStringChar)
{
    std::string jsonParamString(jsonParamStringChar);
    HiveCppPlugin::callEngine(jsonParamString);
}
NS_HIVE_END
#endif
