#include "HIVE_Analytics.h"
#include "HIVE_CppPlugin.h"
#include <sstream>

#if !WITH_EDITOR && PLATFORM_WINDOWS

NS_HIVE_BEGIN

static std::string TrackingTypeToString(Analytics::TrackingType trackingType)
{
    if (trackingType == Analytics::TrackingType::ADJUST)
        return "ADJUST";
    else if (trackingType == Analytics::TrackingType::SINGULAR)
        return "SINGULAR";
    else if (trackingType == Analytics::TrackingType::APPSFLYER)
        return "APPSFLYER";
    else
        return "UNKNOWN";
}

static Analytics::onShowConsentMode g_AnalyticsShowConsentModeIfRequire;
static Analytics::onShowConsentMode g_AnalyticsShowConsentMode;

bool Analytics::sendAnalyticsLog(picojson::object& logData)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "sendAnalyticsLog");
    jsonParam["logData"] = picojson::value(logData);

    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);

    bool bIsLogin = false;
    picojson::value jsonValue = resJson.get("sendAnalyticsLog");
    if (jsonValue.is<picojson::null>() == false)
        bIsLogin = jsonValue.evaluate_as_boolean();

    return bIsLogin;
}


void Analytics::setEnableTracker(TrackingType trackingType, bool isEnable)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "setEnableTracker");

    jsonParam["trackingType"] = picojson::value(TrackingTypeToString(trackingType));
    jsonParam["isEnable"] = picojson::value(isEnable);

    HiveCppPlugin::callNative(jsonParam);
}


void Analytics::setEnableTrackerWithName(std::string name, bool isEnable)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "setEnableTrackerWithName");

    jsonParam["name"] = picojson::value(name);
    jsonParam["isEnable"] = picojson::value(isEnable);

    HiveCppPlugin::callNative(jsonParam);
}


void Analytics::sendEvent(std::string eventName)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "sendEvent");
    jsonParam["eventName"] = picojson::value(eventName);

    HiveCppPlugin::callNative(jsonParam);
}

void Analytics::sendEventWithAttributes(std::string eventName, AnalyticsAttributes const& attributes)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "sendEventWithAttributes");
    jsonParam["eventName"] = picojson::value(eventName);
    jsonParam["attributes"] = picojson::value(attributes.toJson());

    HiveCppPlugin::callNative(jsonParam);
}

void Analytics::sendAdRevenueEvent(AnalyticsAdRevenue analyticsAdRevenue)
{
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "sendAdRevenueEvent");
    jsonParam["analyticsAdRevenue"] = picojson::value(analyticsAdRevenue.toJson());

    HiveCppPlugin::callNative(jsonParam);
}

void Analytics::sendUserEntryFunnelsLogs(std::string funnelTrack, std::string optionTag) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "sendUserEntryFunnelsLogs");
    jsonParam["funnelTrack"] = picojson::value(funnelTrack);
    jsonParam["optionTag"] = picojson::value(optionTag);

    HiveCppPlugin::callNative(jsonParam);
}

unsigned int Analytics::getRemainAnalyticsLogCount() {
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "getRemainAnalyticsLogCount");
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    picojson::value jsonValue = resJson.get("getRemainAnalyticsLogCount");
    if (jsonValue.is<picojson::null>())
        return 0;
    return static_cast<unsigned int>(jsonValue.get<double>());
}

void Analytics::setConsent(std::string providerName, std::map<std::string, std::string> settings) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "setConsent");
    picojson::object settingsObject;
    for (auto it = settings.begin(); it != settings.end(); it++) {
        settingsObject[it->first] = picojson::value(it->second);
    }

    string settingsString = picojson::value(settingsObject).serialize();
    jsonParam["settings"] = picojson::value(settingsString);
    jsonParam["providerName"] = picojson::value(providerName);

    HiveCppPlugin::callNative(jsonParam);
}

std::map<std::string, std::string> Analytics::getConsent(std::string providerName) {
    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "getConsent");
    jsonParam["providerName"] = picojson::value(providerName);
    picojson::value resJson = HiveCppPlugin::callNative(jsonParam);
    picojson::value jsonValue = resJson.get("settings");
    if (jsonValue.is<picojson::null>())
        return {};

    std::string settingsString = jsonValue.to_str();

    picojson::value settingsValue;
    picojson::parse(settingsValue, settingsString);
    picojson::object settingsObject = settingsValue.get<picojson::object>();

    map<std::string, std::string> settings;
    for (auto it = settingsObject.begin(); it != settingsObject.end(); it++) {
        string key = it->first;
        settings[key] = it->second.to_str();
    }

    return settings;
}

void Analytics::showConsentModeIfRequire(bool checkCmp, ConsentMode* consentMode, onShowConsentMode listener) {
    g_AnalyticsShowConsentModeIfRequire = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "showConsentModeIfRequire");
    jsonParam["checkCmp"] = picojson::value(checkCmp);
    if (consentMode != NULL) {
        jsonParam["consentMode"] = picojson::value(consentMode->toJson());
    }

    HiveCppPlugin::callNative(jsonParam);
}

void Analytics::showConsentMode(ConsentMode* consentMode, onShowConsentMode listener) {
    g_AnalyticsShowConsentMode = listener;

    picojson::object jsonParam = HiveCppPlugin::createParam("Analytics", "showConsentMode");
    if (consentMode != NULL) {
        jsonParam["consentMode"] = picojson::value(consentMode->toJson());
    }

    HiveCppPlugin::callNative(jsonParam);
}

void Analytics::executeEngine(picojson::value jsonParam)
{
    ResultAPI result;

    if (!jsonParam.get("resultAPI").is<picojson::null>()) {
        result = ResultAPI(jsonParam.get("resultAPI"));
    }

    std::string methodName = jsonParam.get("method").to_str();
    if (methodName.compare("showConsentModeIfRequire") == 0) {
        if (g_AnalyticsShowConsentModeIfRequire != nullptr) {
            std::vector<ConsentStatus> statusList;

            if (!jsonParam.get("statusList").is<picojson::null>()) {
                auto jsonList = jsonParam.get("statusList").get<picojson::array>();
                for (auto it = jsonList.begin(); it != jsonList.end(); ++it) {
                    statusList.push_back(ConsentStatus(*it));
                }
            }
            g_AnalyticsShowConsentModeIfRequire(result, statusList);
        }
    }
    else if (methodName.compare("showConsentMode") == 0) {
        if (g_AnalyticsShowConsentMode != nullptr) {
            std::vector<ConsentStatus> statusList;

            if (!jsonParam.get("statusList").is<picojson::null>()) {
                auto jsonList = jsonParam.get("statusList").get<picojson::array>();
                for (auto it = jsonList.begin(); it != jsonList.end(); ++it) {
                    statusList.push_back(ConsentStatus(*it));
                }
            }
            g_AnalyticsShowConsentMode(result, statusList);
        }
    }

}

// MARK: AnalyticsAdRevenue class Implements
AnalyticsAdRevenue::AnalyticsAdRevenue()
{
    this->revenue = 0.0;
    this->adPlatform = "";
    this->adUnitId = "";
    this->adType = "";
    this->adPlacement = "";
    this->currency = "USD";
}

AnalyticsAdRevenue::AnalyticsAdRevenue(double arg_revenue, std::string arg_adPlatform, std::string arg_adUnitId, std::string arg_adType, std::string arg_adPlacement, std::string arg_currency)
{
    this->revenue = arg_revenue;
    this->adPlatform = arg_adPlatform;
    this->adUnitId = arg_adUnitId;
    this->adType = arg_adType;
    this->adPlacement = arg_adPlacement;
    this->currency = arg_currency;
}

AnalyticsAdRevenue::AnalyticsAdRevenue(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
        return;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("revenue");
    if (jsonValue.is<picojson::null>() == false)
        this->revenue = jsonValue.get<double>();
    else this->revenue = 0.0;

    jsonValue = jsonParam.get("adPlatform");
    if (jsonValue.is<picojson::null>() == false)
        this->adPlatform = jsonValue.to_str();
    else this->adPlatform = "";

    jsonValue = jsonParam.get("adUnitId");
    if (jsonValue.is<picojson::null>() == false)
        this->adUnitId = jsonValue.to_str();
    else this->adUnitId = "";

    jsonValue = jsonParam.get("adType");
    if (jsonValue.is<picojson::null>() == false)
        this->adType = jsonValue.to_str();
    else this->adType = "";


    jsonValue = jsonParam.get("adPlacement");
    if (jsonValue.is<picojson::null>() == false)
        this->adPlacement = jsonValue.to_str();
    else this->adPlacement = "";

    jsonValue = jsonParam.get("currency");
    if (jsonValue.is<picojson::null>() == false)
        this->currency = jsonValue.to_str();
    else this->currency = "USD";
}


picojson::object AnalyticsAdRevenue::toJson() const
{
    picojson::object resJson;
    resJson["revenue"] = picojson::value(this->revenue);
    resJson["adPlatform"] = picojson::value(this->adPlatform);
    resJson["adUnitId"] = picojson::value(this->adUnitId);
    resJson["adType"] = picojson::value(this->adType);
    resJson["adPlacement"] = picojson::value(this->adPlacement);
    resJson["currency"] = picojson::value(this->currency);

    return resJson;
}


std::string AnalyticsAdRevenue::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// MARK: ConsentStatus class Implements

ConsentStatus::ConsentStatus() {
    this->id = "";
    this->granted = "not-set";
    this->consentDate = 0;
    this->expiredDate = 0;
}

ConsentStatus::ConsentStatus(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
        return;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("id");
    if (jsonValue.is<picojson::null>() == false)
        this->id = jsonValue.to_str();
    else this->id = "";

    jsonValue = jsonParam.get("granted");
    if (jsonValue.is<picojson::null>() == false)
        this->granted = jsonValue.to_str();
    else this->granted = "not-set";

    jsonValue = jsonParam.get("consentDate");
    if (jsonValue.is<picojson::null>() == false)
        this->consentDate = (long)jsonValue.get<double>();
    else this->consentDate = 0;

    jsonValue = jsonParam.get("expiredDate");
    if (jsonValue.is<picojson::null>() == false)
        this->expiredDate = (long)jsonValue.get<double>();
    else this->expiredDate = 0;

}

picojson::object ConsentStatus::toJson() const
{
    picojson::object resJson;
    std::stringstream ss;
    resJson["id"] = picojson::value(this->id);
    resJson["granted"] = picojson::value(this->granted);

    ss.str("");
    ss << this->consentDate;
    resJson["consentDate"] = picojson::value(ss.str());
    ss.str("");
    ss << this->expiredDate;
    resJson["expiredDate"] = picojson::value(ss.str());

    return resJson;
}

std::string ConsentStatus::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// MARK: ConsentForm class Implements

ConsentForm::ConsentForm() {
    this->id = "";
    this->retentionPeriod = 0;
    this->title = "";
    this->content = "";
    this->subForms = std::vector<ConsentForm>();
}

ConsentForm::ConsentForm(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
        return;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("id");
    if (jsonValue.is<picojson::null>() == false)
        this->id = jsonValue.to_str();
    else this->id = "";

    jsonValue = jsonParam.get("retentionPeriod");
    if (jsonValue.is<picojson::null>() == false)
        this->retentionPeriod = (int)jsonValue.get<double>();
    else this->retentionPeriod = 0;

    jsonValue = jsonParam.get("title");
    if (jsonValue.is<picojson::null>() == false)
        this->title = jsonValue.to_str();
    else this->title = "";

    jsonValue = jsonParam.get("content");
    if (jsonValue.is<picojson::null>() == false)
        this->content = jsonValue.to_str();
    else this->content = "";

    jsonValue = jsonParam.get("subForms");
    if (jsonValue.is<picojson::null>() == false && jsonValue.is<picojson::array>()) {
        picojson::array subFormsJson = jsonValue.get<picojson::array>();
        for (picojson::array::iterator iter = subFormsJson.begin(); iter != subFormsJson.end(); ++iter) {
            this->subForms.push_back(ConsentForm(*iter));
        }
    }
}

picojson::object ConsentForm::toJson() const
{
    picojson::object resJson;
    std::stringstream ss;
    resJson["id"] = picojson::value(this->id);
    ss.str("");
    ss << this->retentionPeriod;
    resJson["retentionPeriod"] = picojson::value(ss.str());
    resJson["title"] = picojson::value(this->title);
    resJson["content"] = picojson::value(this->content);

    picojson::array subFormsArray;
    for (const auto& subForm : subForms) {
        picojson::object subFormObj = subForm.toJson();
        subFormsArray.push_back(picojson::value(subFormObj));
    }
    resJson["subForms"] = picojson::value(subFormsArray);
    return resJson;
}

std::string ConsentForm::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// MARK: ConsentMode class Implements

ConsentMode::ConsentMode() {
    this->title = "";
    this->companyName = "";
    this->privacyPolicy = "";
    this->adUserData = NULL;
    this->adPersonalization = NULL;
    this->analyticsStorage = NULL;
}

ConsentMode::~ConsentMode() {
    delete adUserData;
    delete adPersonalization;
    delete analyticsStorage;
}

ConsentMode::ConsentMode(picojson::value jsonParam)
{
    if (jsonParam.is<picojson::null>())
        return;

    picojson::value jsonValue;

    jsonValue = jsonParam.get("title");
    if (jsonValue.is<picojson::null>() == false)
        this->title = jsonValue.to_str();
    else this->title = "";

    jsonValue = jsonParam.get("companyName");
    if (jsonValue.is<picojson::null>() == false)
        this->companyName = jsonValue.to_str();
    else this->companyName = "";

    jsonValue = jsonParam.get("privacyPolicy");
    if (jsonValue.is<picojson::null>() == false)
        this->privacyPolicy = jsonValue.to_str();
    else this->privacyPolicy = "";

    jsonValue = jsonParam.get("adUserData");
    if (jsonValue.is<picojson::null>() == false)
        this->adUserData = new ConsentForm(jsonValue);
    else this->adUserData = NULL;

    jsonValue = jsonParam.get("adPersonalization");
    if (jsonValue.is<picojson::null>() == false)
        this->adPersonalization = new ConsentForm(jsonValue);
    else this->adPersonalization = NULL;

    jsonValue = jsonParam.get("analyticsStorage");
    if (jsonValue.is<picojson::null>() == false)
        this->analyticsStorage = new ConsentForm(jsonValue);
    else this->analyticsStorage = NULL;
}

picojson::object ConsentMode::toJson() const
{
    picojson::object resJson;

    resJson["title"] = picojson::value(this->title);
    resJson["companyName"] = picojson::value(this->companyName);
    resJson["privacyPolicy"] = picojson::value(this->privacyPolicy);
    if (this->adUserData != NULL)
        resJson["adUserData"] = picojson::value(this->adUserData->toJson());

    if (this->adPersonalization != NULL)
        resJson["adPersonalization"] = picojson::value(this->adPersonalization->toJson());

    if (this->analyticsStorage != NULL)
        resJson["analyticsStorage"] = picojson::value(this->analyticsStorage->toJson());

    return resJson;
}

std::string ConsentMode::toString() const
{
    picojson::object resJson = this->toJson();
    std::string resJsonString = picojson::value(resJson).serialize();
    return resJsonString;
}

// MARK: AnalyticsAttributes class Implements
AnalyticsAttributes::AnalyticsAttributes() {
    customAttributes = picojson::object(); // 빈 JSON 객체로 초기화
    moduleSpecificAttributes = picojson::object(); // 빈 JSON 객체로 초기화
}

// CustomAttribute 추가
void AnalyticsAttributes::addCustomAttribute(const std::string& key, const picojson::value& value) {
    customAttributes[key] = value;
}

// ModuleSpecificAttribute 추가
void AnalyticsAttributes::addModuleSpecificAttribute(const IAnalyticsSpecific& specific) {
    moduleSpecificAttributes[specific.providerName] = picojson::value(specific.toJson());
}

picojson::object AnalyticsAttributes::toJson() const {
    picojson::object json;
    json["customAttributes"] = picojson::value(customAttributes); // customAttributes를 키 값으로 설정
    json["moduleSpecificAttributes"] = picojson::value(moduleSpecificAttributes); // moduleSpecificAttributes를 키 값으로 설정
    return json;
}
std::string AnalyticsAttributes::toString() const {
    return picojson::value(toJson()).serialize(); // JSON을 문자열로 변환
}

// MARK: IAnalyticsSpecific class Implements
IAnalyticsSpecific::IAnalyticsSpecific() {
    providerName = "unknown";
}

picojson::object IAnalyticsSpecific::toJson() const {
    picojson::object json;
    return json;
}
std::string IAnalyticsSpecific::toString() const {
    return picojson::value(toJson()).serialize(); // JSON을 문자열로 변환
}

// MARK: AirbridgeSpecific class Implements

AirbridgeSpecific::AirbridgeSpecific() : IAnalyticsSpecific() {
    providerName = "airbridge";
    semanticAttributes = picojson::object(); // 빈 JSON 객체로 초기화
}

void AirbridgeSpecific::setSemanticAction(const std::string& value) {
    semanticAttributes["action"] = picojson::value(value);
}
void AirbridgeSpecific::setSemanticLabel(const std::string& value) {
    semanticAttributes["label"] = picojson::value(value);
}
void AirbridgeSpecific::setSemanticValue(const double value) {
    semanticAttributes["value"] = picojson::value(static_cast<double>(value));
}

// SemanticAttribute 추가
void AirbridgeSpecific::addSemanticAttribute(const std::string& key, const picojson::value& value) {
    semanticAttributes[key] = value;
}

// JSON 변환 (부모 클래스와 병합)
picojson::object AirbridgeSpecific::toJson() const {
    picojson::object json = IAnalyticsSpecific::toJson(); // 부모 클래스의 JSON 데이터 가져오기
    json["semanticAttributes"] = picojson::value(semanticAttributes); // 자식 필드 추가
    return json;
}

std::string AirbridgeSpecific::toString() const {
    return picojson::value(toJson()).serialize(); // JSON을 문자열로 변환
}

NS_HIVE_END		// namespace hive

#endif

