// Copyright 1998-2016 Epic Games, Inc. All Rights Reserved.
#include "HIVESDK.h"
#include "CPP/HIVE_CppPlugin.h"
#include "CPP/HIVESDKPrivatePCH.h"
#include "Core.h"
#include "CPP/CEFTextInputMethodContext.h"
#include "CPP/IMEProcess.h"

#include <thread>

#if PLATFORM_WINDOWS
#include "Windows/WindowsHWrapper.h"
#endif
//#include <HIVE_SDK+Plugin/HIVE_CppPlugin.h>

//#include "Kismet/GameplayStatics.h"

#define LOCTEXT_NAMESPACE "FHIVESDKModule"

#if PLATFORM_WINDOWS
LPFN_SET_IME_PROCESS lpfnSetImeProcess = nullptr;
TSharedPtr<FCEFTextInputMethodContext> imeHandler = nullptr;
#endif

#if PLATFORM_IOS
//extern void (*HIVEAuthMaintenanceHelperFuncPtr)();  //use in HIVE SDK
void requestIOSUnrealEngineExit()
{
    FPlatformMisc::RequestExit( true );// need Force  >= UE 4.22.
    [NSThread sleepForTimeInterval:1.0];
}
#endif

#if PLATFORM_WINDOWS

void HIVESDKCEFImeEnable() {
	
	::OutputDebugString(L"HIVESDKCEFImeEnable called\n");

	std::thread([=]() {

		while (true) {

			if (lpfnSetImeProcess == nullptr) {

				HMODULE handle = (HMODULE)FPlatformProcess::GetDllHandle(L"HIVEUIFramework.dll");

				if (handle != NULL) {

					lpfnSetImeProcess
						= (LPFN_SET_IME_PROCESS)FPlatformProcess::GetDllExport(handle, L"setImeProcess");

					if (lpfnSetImeProcess != nullptr) {
						break;
					}
				}
			}
			else {

				break;
			}

			std::this_thread::sleep_for(std::chrono::seconds(1));
		}
	}).detach();

	AsyncTask(ENamedThreads::GameThread, [&]()
		{
			// Code placed here will run in the game thread 
			if (imeHandler == nullptr) {

				imeHandler = MakeShared<FCEFTextInputMethodContext>();
			}

			imeHandler->Enable();			
		});
}

void HIVESDKCEFImeDisable() {
	
	::OutputDebugString(L"HIVESDKCEFImeDisable called\n");

	AsyncTask(ENamedThreads::GameThread, [&]()
		{
			if (imeHandler != nullptr) {

				imeHandler->Disable();
			}
		});
}
#else
void HIVESDKCEFImeEnable() {}
void HIVESDKCEFImeDisable() {}
#endif

void FHIVESDKModule::StartupModule()
{
//		FMessageDialog::Open(EAppMsgType::Ok, LOCTEXT("ThirdPartyLibraryError", "StartUp Module!!"));
#if PLATFORM_IOS
    NSLog(@"HIVE SDK StartUp Module\n");
	// TODO swift version..
//    HIVEAuthMaintenanceHelperFuncPtr = requestIOSUnrealEngineExit;	//	function pointer removed from HIVESDK
#endif
}

void FHIVESDKModule::ShutdownModule()
{
	// This function may be called during shutdown to clean up your module.  For modules that support dynamic reloading,
	// we call this function before unloading the module.

	// Free the dll handle
}

void FHIVESDKModule::HIVESDK_TestFunction()
{

}

// Dummy function HIVE SDK Plugin
extern "C" void UnitySendMessage(const char *, const char *, const char *)
{
    
}

#if PLATFORM_WINDOWS
#include "Windows/WindowsHWrapper.h"
#include <Imm.h>
//#pragma   comment(lib,"imm32.lib")
HIMC HIVEIMMContextId;
//HIMC HIVESavedImmContext;
#endif
void HIVESDKIMEEnable() {
#if PLATFORM_WINDOWS
    void* ParentWindowPtr =
        FSlateApplication::Get().GetActiveTopLevelWindow()->GetNativeWindow()->GetOSWindowHandle();
        //GEngine->GameViewport->GetWindow()->GetNativeWindow()->GetOSWindowHandle();
    //HIVESavedImmContext = ::ImmGetContext((HWND)ParentWindowPtr);
    // Create New
    HIVEIMMContextId = ::ImmCreateContext();
    ::ImmAssociateContext((HWND)ParentWindowPtr, HIVEIMMContextId);
#endif
}
void HIVESDKIMEDisable() {
#if PLATFORM_WINDOWS
    if (HIVEIMMContextId != nullptr) {
        //void* ParentWindowPtr =
        //    FSlateApplication::Get().GetActiveTopLevelWindow()->GetNativeWindow()->GetOSWindowHandle();
        //::ImmAssociateContext((HWND)ParentWindowPtr, HIVESavedImmContext);
        ::ImmDestroyContext(HIVEIMMContextId);
    }
#endif
}
#undef LOCTEXT_NAMESPACE

IMPLEMENT_MODULE(FHIVESDKModule, HIVESDK)
