/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "HiveConfiguration.h"
#include "HiveUELogger.h"
#include "HiveMacros.h"


HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetConfiguration, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetHiveSDKVersion, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetReferenceSDKVersion, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetAppId, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetAppId, (const FString& AppId), (AppId))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetHiveCertificationKey, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetHiveCertificationKey, (const FString& Key), (Key))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, EHiveZoneType, GetZone, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetZone, (const EHiveZoneType& Type), (Type))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetServerId, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetServerId, (const FString& ServerId), (ServerId))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, UpdateServerId, (const FString& ServerId), (ServerId))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetGameLanguage, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetGameLanguage, (const FString& Language), (Language))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, UpdateGameLanguage, (const FString& Language), (Language))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, bool, GetUseLog, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetUseLog, (bool bUseLog), (bUseLog))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetCompany, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetCompany, (const FString& Company), (Company))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetChannel, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetChannel, (const FString& Channel), (Channel))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, int32, GetHttpConnectTimeout, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetHttpConnectTimeout, (int32 second), (second))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, int32, GetHttpReadTimeout, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetHttpReadTimeout, (int32 second), (second))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, int32, GetMaxGameLogSize, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetMaxGameLogSize, (int32 size), (size))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetMarket, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetMarket, (const FString& Market), (Market))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetHiveCountry, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, FString, GetHiveTimeZone, (), ())
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, uint32, GetAnalyticsSendLimit, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetAnalyticsSendLimit, (uint32 Limit), (Limit))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, uint32, GetAnalyticsQueueLimit, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetAnalyticsQueueLimit, (uint32 Limit), (Limit))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, float, GetAnalyticsSendCycleSeconds, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetAnalyticsSendCycleSeconds, (float seconds), (seconds))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, bool, GetAgeGateU13, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetAgeGateU13, (bool bEnable), (bEnable))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, EHiveThemeType, GetHiveTheme, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetHiveTheme, (EHiveThemeType Type), (Type))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetHiveOrientation, (const FString& Orientation), (Orientation))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetConfigurations, (EHiveConfigType Type, const FString& Value), (Type, Value))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, GetMetaData, (const FString& Key, bool bForceReload, const FHiveConfigurationOnMetaDataDelegate& Delegate), (Key, bForceReload, Delegate))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetUseHercules, (bool bEnable), (bEnable))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, bool, GetCrossPromotionBannerShowing, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetCrossPromotionBannerShowing, (bool showing), (showing))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, bool, GetAgeGateU16Agree, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetUsePrivateBrowsingForAuth, (bool use), (use))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, bool, GetEnableGameController, (), ())
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetEnableGameController, (bool enable), (enable))
HIVE_CALL_IMPL_VOID_METHOD(FHiveConfiguration, SetChatConnectionTimeout, (int32 Seconds), (Seconds))
HIVE_CALL_IMPL_RETURN_METHOD(FHiveConfiguration, int32, GetChatConnectionTimeout, (), ())

bool FHiveConfiguration::GetLegalGuardianConsentMode()
{
    return GetInstance()->GetLegalGuardianConsentAgree();
}
