/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveConfigurationImpl.h"
#include "HiveUELogger.h"

FString IHiveConfigurationImpl::GetConfiguration()
{
    std::string config = hive::Configuration::getConfiguration();
    FString Result = FString(UTF8_TO_TCHAR(config.c_str()));
    return Result;
}

FString IHiveConfigurationImpl::GetHiveSDKVersion()
{
    std::string version = hive::Configuration::getHiveSDKVersion();
    FString Result = FString(UTF8_TO_TCHAR(version.c_str()));
    return Result;
}

FString IHiveConfigurationImpl::GetReferenceSDKVersion()
{
    std::string version = hive::Configuration::getReferenceSDKVersion();
    FString Result = FString(UTF8_TO_TCHAR(version.c_str()));
    return Result;
}

FString IHiveConfigurationImpl::GetAppId()
{
    std::string appId = hive::Configuration::getAppId();
    FString Result = FString(UTF8_TO_TCHAR(appId.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetAppId(const FString& AppId)
{
    std::string StrAppId(TCHAR_TO_UTF8(*AppId));
    hive::Configuration::setAppId(StrAppId);
}

FString IHiveConfigurationImpl::GetHiveCertificationKey()
{
    std::string key = hive::Configuration::getHiveCertificationKey();
    FString Result = FString(UTF8_TO_TCHAR(key.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetHiveCertificationKey(const FString& Key)
{
    std::string StrKey(TCHAR_TO_UTF8(*Key));
    hive::Configuration::setHiveCertificationKey(StrKey);
}

EHiveZoneType IHiveConfigurationImpl::GetZone()
{
    hive::ZoneType zoneType = hive::Configuration::getZone();
    return static_cast<EHiveZoneType>(zoneType);
}

void IHiveConfigurationImpl::SetZone(const EHiveZoneType& Type)
{
    hive::Configuration::setZone(static_cast<hive::ZoneType>(Type));
}

FString IHiveConfigurationImpl::GetServerId()
{
    std::string serverId = hive::Configuration::getServerId();
    FString Result = FString(UTF8_TO_TCHAR(serverId.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetServerId(const FString& ServerId)
{
    std::string StrServerId(TCHAR_TO_UTF8(*ServerId));
    hive::Configuration::setServerId(StrServerId);
}

void IHiveConfigurationImpl::UpdateServerId(const FString& ServerId)
{
    std::string StrServerId(TCHAR_TO_UTF8(*ServerId));
    hive::Configuration::updateServerId(StrServerId);
}

FString IHiveConfigurationImpl::GetGameLanguage() 
{
    std::string gameLanguage = hive::Configuration::getGameLanguage();
    FString Result = FString(UTF8_TO_TCHAR(gameLanguage.c_str()));

    return Result;
}

void IHiveConfigurationImpl::SetGameLanguage(const FString& Language)
{
    std::string StrLanguage(TCHAR_TO_UTF8(*Language));
    hive::Configuration::setGameLanguage(StrLanguage);
}

void IHiveConfigurationImpl::UpdateGameLanguage(const FString& Language)
{
    std::string StrLanguage(TCHAR_TO_UTF8(*Language));
    hive::Configuration::updateGameLanguage(StrLanguage);
}

bool IHiveConfigurationImpl::GetUseLog()
{
    return hive::Configuration::getUseLog();
}

void IHiveConfigurationImpl::SetUseLog(bool bUseLog)
{
    hive::Configuration::setUseLog(bUseLog);
}

FString IHiveConfigurationImpl::GetCompany()
{
    std::string company = hive::Configuration::getCompany();
    FString Result = FString(UTF8_TO_TCHAR(company.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetCompany(const FString& Company)
{
    std::string StrCompany(TCHAR_TO_UTF8(*Company));
    hive::Configuration::setCompany(StrCompany);
}

FString IHiveConfigurationImpl::GetChannel()
{
    std::string channel = hive::Configuration::getChannel();
    FString Result = FString(UTF8_TO_TCHAR(channel.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetChannel(const FString& Channel)
{
    std::string StrChannel(TCHAR_TO_UTF8(*Channel));
    hive::Configuration::setChannel(StrChannel);
}

int32 IHiveConfigurationImpl::GetHttpConnectTimeout()
{
    return hive::Configuration::getHttpConnectTimeout();
}

void IHiveConfigurationImpl::SetHttpConnectTimeout(int32 second)
{
    hive::Configuration::setHttpConnectTimeout(second);
}

int32 IHiveConfigurationImpl::GetHttpReadTimeout()
{
    return hive::Configuration::getHttpReadTimeout();
}

void IHiveConfigurationImpl::SetHttpReadTimeout(int32 second)
{
    hive::Configuration::setHttpReadTimeout(second);
}

int32 IHiveConfigurationImpl::GetMaxGameLogSize()
{
    return hive::Configuration::getMaxGameLogSize();
}

void IHiveConfigurationImpl::SetMaxGameLogSize(int32 size)
{
    hive::Configuration::setMaxGameLogSize(size);
}

FString IHiveConfigurationImpl::GetMarket()
{
    std::string market = hive::Configuration::getMarket();
    FString Result = FString(UTF8_TO_TCHAR(market.c_str()));
    return Result;
}

void IHiveConfigurationImpl::SetMarket(const FString& Market)
{
    std::string StrMarket(TCHAR_TO_UTF8(*Market));
    hive::Configuration::setMarket(StrMarket);
}

FString IHiveConfigurationImpl::GetHiveCountry()
{
    std::string country = hive::Configuration::getHiveCountry();
    FString Result = FString(UTF8_TO_TCHAR(country.c_str()));
    return Result;
}

FString IHiveConfigurationImpl::GetHiveTimeZone()
{
    std::string timeZone = hive::Configuration::getHiveTimeZone();
    FString Result = FString(UTF8_TO_TCHAR(timeZone.c_str()));
    return Result;
}

uint32 IHiveConfigurationImpl::GetAnalyticsSendLimit()
{
    return hive::Configuration::getAnalyticsSendLimit();
}

void IHiveConfigurationImpl::SetAnalyticsSendLimit(uint32 Limit)
{
    hive::Configuration::setAnalyticsSendLimit(Limit);
}

uint32 IHiveConfigurationImpl::GetAnalyticsQueueLimit()
{
    return hive::Configuration::getAnalyticsQueueLimit();
}

void IHiveConfigurationImpl::SetAnalyticsQueueLimit(uint32 Limit)
{
    hive::Configuration::setAnalyticsQueueLimit(Limit);
}

float IHiveConfigurationImpl::GetAnalyticsSendCycleSeconds()
{
    return hive::Configuration::getAnalyticsSendCycleSeconds();
}

void IHiveConfigurationImpl::SetAnalyticsSendCycleSeconds(float seconds)
{
    hive::Configuration::setAnalyticsSendCycleSeconds(seconds);
}

bool IHiveConfigurationImpl::GetAgeGateU13()
{
    return hive::Configuration::getAgeGateU13();
}

void IHiveConfigurationImpl::SetAgeGateU13(bool bEnable)
{
    hive::Configuration::setAgeGateU13(bEnable);
}

EHiveThemeType IHiveConfigurationImpl::GetHiveTheme()
{
    hive::HiveThemeType type = hive::Configuration::getHiveTheme();
    return static_cast<EHiveThemeType>(type);
}

void IHiveConfigurationImpl::SetHiveTheme(EHiveThemeType Type)
{
    hive::HiveThemeType type = static_cast<hive::HiveThemeType>(Type);
    hive::Configuration::setHiveTheme(type);
}

void IHiveConfigurationImpl::SetHiveOrientation(const FString& Orientation)
{
    std::string StrOrientation(TCHAR_TO_UTF8(*Orientation));
    hive::Configuration::setHiveOrientation(StrOrientation);
}

void IHiveConfigurationImpl::SetConfigurations(EHiveConfigType Type, const FString& Value)
{
    hive::HiveConfigType type = static_cast<hive::HiveConfigType>(Type);
    std::string StrValue(TCHAR_TO_UTF8(*Value));

    hive::Configuration::setConfigurations(type, StrValue);
}

void IHiveConfigurationImpl::GetMetaData(const FString& Key, bool bForceReload, const FHiveConfigurationOnMetaDataDelegate& Delegate)
{
    std::string StrKey(TCHAR_TO_UTF8(*Key));
    hive::Configuration::getMetaData(StrKey, bForceReload, [Delegate](hive::ResultAPI const & result, std::string value) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FString Value = FString(UTF8_TO_TCHAR(value.c_str()));

            Delegate.Execute(Result, Value);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveConfigurationImpl::SetUseHercules(bool bEnable)
{
    hive::Configuration::setUseHercules(bEnable);
}

void IHiveConfigurationImpl::SetCrossPromotionBannerShowing(bool showing)
{
    hive::Configuration::setCrossPromotionBannerShowing(showing);
}

bool IHiveConfigurationImpl::GetCrossPromotionBannerShowing()
{
    return hive::Configuration::getCrossPromotionBannerShowing();
}

bool IHiveConfigurationImpl::GetAgeGateU16Agree()
{
    return hive::Configuration::getAgeGateU16Agree();
}

bool IHiveConfigurationImpl::GetLegalGuardianConsentAgree()
{
    return hive::Configuration::getLegalGuardianConsentAgree();
}

void IHiveConfigurationImpl::SetUsePrivateBrowsingForAuth(bool use)
{
    hive::Configuration::setUsePrivateBrowsingForAuth(use);
}

bool IHiveConfigurationImpl::GetEnableGameController()
{
    return hive::Configuration::getEnableGameController();
}

void IHiveConfigurationImpl::SetEnableGameController(bool enable)
{
    hive::Configuration::setEnableGameController(enable);
}

void  IHiveConfigurationImpl::SetChatConnectionTimeout(int32 Seconds)
{
    hive::Configuration::setChatConnectionTimeout(Seconds);
}

int32 IHiveConfigurationImpl::GetChatConnectionTimeout()
{
    return hive::Configuration::getChatConnectionTimeout();
}