/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveLoggerImpl.h"
#include "HiveUELogger.h"

void IHiveLoggerImpl::SetLoggerDelegate(const FHiveLoggerOnLogDelegate& Delegate)
{
    hive::Logger::setLoggerListener([Delegate](std::string const & tag, std::string const & level, std::string const & logMessage) {
        if (Delegate.IsBound())
        {
            FString Tag = FString(UTF8_TO_TCHAR(tag.c_str()));
            FString Level = FString(UTF8_TO_TCHAR(level.c_str()));
            FString LogMessage = FString(UTF8_TO_TCHAR(logMessage.c_str()));

            Delegate.Execute(Tag, Level, LogMessage);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveLoggerImpl::Log(const FString& Message)
{
    std::string StrMessage(TCHAR_TO_UTF8(*Message));
    hive::Logger::log(StrMessage.c_str());
}

bool IHiveLoggerImpl::IsActivateLogging()
{
    return hive::Logger::isActivateLogging();
}

void IHiveLoggerImpl::SetLogFilter(const FHiveLogFilter& LogFilter)
{
    hive::LogType coreLog = static_cast<hive::LogType>(LogFilter.CoreLog);
    hive::LogType serviceLog = static_cast<hive::LogType>(LogFilter.ServiceLog);

    hive::LogFilter logFilter = hive::LogFilter();
    logFilter.coreLog = coreLog;
    logFilter.serviceLog = serviceLog;

    hive::Logger::setLogFilter(logFilter);
}