/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveMatchMakingImpl.h"
#include "HiveUELogger.h"

void IHiveMatchMakingImpl::RequestMatchMaking(int32 MatchId, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingDataDelegate& Delegate)
{
    FTCHARToUTF8 ExtraDataConverter(*ExtraData);
    const char* StrExtraData = ExtraDataConverter.Get();
    hive::MatchMaking::requestMatchMaking(MatchId, Point, StrExtraData, [Delegate](hive::ResultAPI const & result, hive::MatchMakingData const & matchMakingData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingData MatchMakingData(matchMakingData);
            Delegate.Execute(Result, MatchMakingData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::GetRequestingStatus(int32 MatchId, const FHiveMatchMakingOnMatchMakingDataDelegate& Delegate)
{
    hive::MatchMaking::getRequestingStatus(MatchId, [Delegate](hive::ResultAPI const & result, hive::MatchMakingData const & matchMakingData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingData MatchMakingData(matchMakingData);
            Delegate.Execute(Result, MatchMakingData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::DeleteRequesting(int32 MatchId, const FHiveMatchMakingOnResultDelegate& Delegate)
{
    hive::MatchMaking::deleteRequesting(MatchId, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::CreateGroup(int32 MatchId, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    FTCHARToUTF8 ExtraDataConverter(*ExtraData);
    const char* StrExtraData = ExtraDataConverter.Get();
    hive::MatchMaking::createGroup(MatchId, Point, StrExtraData, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::JoinGroup(int32 MatchId, const FString& GroupCode, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    FTCHARToUTF8 GroupCodeConverter(*GroupCode);
    FTCHARToUTF8 ExtraDataConverter(*ExtraData);
    const char* StrGroupCode = GroupCodeConverter.Get();
    const char* StrExtraData = ExtraDataConverter.Get();
    hive::MatchMaking::joinGroup(MatchId, StrGroupCode, Point, StrExtraData, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::LeaveGroup(int32 MatchId, const FHiveMatchMakingOnResultDelegate& Delegate)
{
    hive::MatchMaking::leaveGroup(MatchId, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::KickGroupUser(int32 MatchId, int64 TargetPlayerId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate) 
{
    hive::MatchMaking::kickGroupUser(MatchId, TargetPlayerId, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::GetGroupInfoByUser(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate) 
{
    hive::MatchMaking::getGroupInfoByUser(MatchId, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::GetGroupInfoByGroupCode(const FString& GroupCode, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    FTCHARToUTF8 GroupCodeConverter(*GroupCode);
    const char* StrGroupCode = GroupCodeConverter.Get();
    hive::MatchMaking::getGroupInfoByGroupCode(StrGroupCode, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::UpdateGroupUser(int32 MatchId, bool Ready, int32 Point, const FString& ExtraData, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    FTCHARToUTF8 ExtraDataConverter(*ExtraData);
    const char* StrExtraData = ExtraDataConverter.Get();
    hive::MatchMaking::updateGroupUser(MatchId, Ready, Point, StrExtraData, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::RequestGroupMatching(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    hive::MatchMaking::requestGroupMatching(MatchId, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveMatchMakingImpl::DeleteGroupMatching(int32 MatchId, const FHiveMatchMakingOnMatchMakingGroupDataDelegate& Delegate)
{
    hive::MatchMaking::deleteGroupMatching(MatchId, [Delegate](hive::ResultAPI const & result, hive::MatchMakingGroupData const & groupData) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FHiveMatchMakingGroupData GroupData(groupData);
            Delegate.Execute(Result, GroupData);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}