/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HivePromotionImpl.h"
#include "HiveUELogger.h"

void IHivePromotionImpl::ShowPromotion(const EHivePromotionType& PromotionType,  bool IsForced, const FHivePromotionViewDelegate& Delegate)
{
    hive::Promotion::showPromotion(
        static_cast<hive::PromotionType>(PromotionType),
        IsForced,
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {           
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::ShowCustomContents(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionViewDelegate& Delegate)
{
    std::string StrContentsKey(TCHAR_TO_UTF8(*ContentsKey));
    hive::Promotion::showCustomContents(
        static_cast<hive::PromotionCustomType>(PromotionCustomType),
        StrContentsKey,
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::ShowCustomContentsOnGameWindow(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionViewDelegate& Delegate)
{
    std::string StrContentsKey(TCHAR_TO_UTF8(*ContentsKey));
    hive::Promotion::showCustomContentsOnGameWindow(
        static_cast<hive::PromotionCustomType>(PromotionCustomType),
        StrContentsKey,
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

EHiveOfferwallState IHivePromotionImpl::GetOfferwallState()
{
    hive::OfferwallState state = hive::Promotion::getOfferwallState();
    return static_cast<EHiveOfferwallState>(state);
}

void IHivePromotionImpl::ShowOfferwall(const FHivePromotionViewDelegate& Delegate)
{
    hive::Promotion::showOfferwall(
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::ShowNews(const FString& Menu, const TArray<int32>& GiftPidList, const FHivePromotionViewDelegate& Delegate)
{
    std::string StrMenu(TCHAR_TO_UTF8(*Menu));
    std::vector<int> giftPids;
    for (const auto& item : GiftPidList)
    {
        giftPids.push_back(item);
    }
    hive::Promotion::showNews(StrMenu, giftPids,
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::ShowNativeReview()
{
    hive::Promotion::showNativeReview(
        [this](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            // Native(Android, iOS) API is an API without callbacks,
            // but only cpp implements the callback form(do nothing).
        }
    );
}

void IHivePromotionImpl::ShowReview(const FHivePromotionViewDelegate& Delegate)
{
    hive::Promotion::showReview(
        [this, Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            HandleCEFImeForPromotionEvent(promotionEventType);

            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::ShowExit(const FHivePromotionViewDelegate& Delegate)
{
    hive::Promotion::showExit(
        [Delegate](hive::ResultAPI const & result, hive::PromotionEventType promotionEventType) {
            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                EHivePromotionEventType PromotionEventType = static_cast<EHivePromotionEventType>(promotionEventType);

                Delegate.Execute(Result, PromotionEventType);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::GetViewInfo(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionOnViewInfoDelegate& Delegate)
{
    std::string StrContentsKey(TCHAR_TO_UTF8(*ContentsKey));
    hive::Promotion::getViewInfo(
        static_cast<hive::PromotionCustomType>(PromotionCustomType),
        StrContentsKey,
        [Delegate](hive::ResultAPI const & result, std::vector<hive::PromotionViewInfo> const & promotionViewInfo) {
            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                
                TArray<FHivePromotionViewInfo> PromotionViewInfoArray;

                if (promotionViewInfo.size() > 0)
                {
                    PromotionViewInfoArray.Reserve(promotionViewInfo.size());

                    for(const auto& item : promotionViewInfo)
                    {
                        FHivePromotionViewInfo PromotionViewInfo(item);
                        PromotionViewInfoArray.Emplace(PromotionViewInfo);
                    }
                }

                Delegate.Execute(Result, PromotionViewInfoArray);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::GetBadgeInfo(const FHivePromotionOnBadgeInfoDelegate& Delegate)
{
    hive::Promotion::getBadgeInfo([Delegate](hive::ResultAPI const & result, std::vector<hive::PromotionBadgeInfo> const & badgeInfoList){
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            
            TArray<FHivePromotionBadgeInfo> PromotionBadgeInfoArray;
            
            if (badgeInfoList.size() > 0)
            {
                PromotionBadgeInfoArray.Reserve(badgeInfoList.size());

                for(const auto& item : badgeInfoList)
                {
                    FHivePromotionBadgeInfo PromotionBadgeInfo(item);
                    PromotionBadgeInfoArray.Emplace(PromotionBadgeInfo);
                }
            }

            Delegate.Execute(Result, PromotionBadgeInfoArray);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePromotionImpl::GetBannerInfo(const EHivePromotionCampaignType& CampaignType, const EHivePromotionBannerType& BannerType, const FHivePromotionOnBannerInfoDelegate& Delegate)
{
    hive::Promotion::getBannerInfo(
        static_cast<hive::PromotionCampaignType>(CampaignType),
        static_cast<hive::PromotionBannerType>(BannerType),
        [Delegate](hive::ResultAPI const & result, std::vector<hive::PromotionBannerInfo> const & bannerInfoList) {
            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                
                TArray<FHivePromotionBannerInfo> PromotionBannerInfoArray;

                if (bannerInfoList.size() > 0)
                {
                    PromotionBannerInfoArray.Reserve(bannerInfoList.size());
                    for(const auto& item : bannerInfoList)
                    {
                        FHivePromotionBannerInfo PromotionBannerInfo(item);
                        PromotionBannerInfoArray.Emplace(PromotionBannerInfo);
                    }
                }

                Delegate.Execute(Result, PromotionBannerInfoArray);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );
}

void IHivePromotionImpl::GetBannerInfoString(const FString& CampaignString, const FString& BannerString, const FHivePromotionOnBannerInfoDelegate& Delegate)
{
    std::string StrCampaignString(TCHAR_TO_UTF8(*CampaignString));
    std::string StrBannerString(TCHAR_TO_UTF8(*BannerString));

    hive::Promotion::getBannerInfoString(
        StrCampaignString,
        StrBannerString,
        [Delegate](hive::ResultAPI const & result, std::vector<hive::PromotionBannerInfo> const & bannerInfoList) {
            if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                
                TArray<FHivePromotionBannerInfo> PromotionBannerInfoArray;

                if (bannerInfoList.size() > 0)
                {
                    PromotionBannerInfoArray.Reserve(bannerInfoList.size());

                    for(const auto& item : bannerInfoList)
                    {
                        FHivePromotionBannerInfo PromotionBannerInfo(item);
                        PromotionBannerInfoArray.Emplace(PromotionBannerInfo);
                    }
                }

                Delegate.Execute(Result, PromotionBannerInfoArray);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
            }
        }
    );

}

void IHivePromotionImpl::GetAppInvitationData(const FHivePromotionOnAppInvitationDataDelegate& Delegate)
{
    hive::Promotion::getAppInvitationData([Delegate](hive::ResultAPI const & result, hive::AppInvitationData const & appInvitationData) {
        if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);
                
                FHiveAppInvitationData AppInvitationData(appInvitationData);

                Delegate.Execute(Result, AppInvitationData);
            }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePromotionImpl::SetAdditionalInfo(const FString& AdditionalInfo)
{
    std::string StrAdditionalInfo(TCHAR_TO_UTF8(*AdditionalInfo));
    hive::Promotion::setAdditionalInfo(StrAdditionalInfo);
}

TOptional<FHiveResultAPI> IHivePromotionImpl::SetEngagementReady(bool IsReady)
{
    hive::ResultAPI result = hive::Promotion::setEngagementReady(IsReady);
    TOptional<FHiveResultAPI> ResultAPI = TOptional<FHiveResultAPI>(FHiveResultAPI(result));
    return ResultAPI;
}

bool IHivePromotionImpl::ProcessURI(const FString& URI)
{
    std::string StrURI(TCHAR_TO_UTF8(*URI));
    return hive::Promotion::processURI(StrURI);
}

void IHivePromotionImpl::SetEngagementDelegate(const FHivePromotionOnEngagementDelegate& Delegate)
{
    hive::Promotion::setEngagementHandler([Delegate](hive::ResultAPI const & result,
                    hive::EngagementEventType engagementEventType,
                    hive::EngagementEventState engagementEventState,
                    picojson::value const & param) {

        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            
            std::string jsonString = param.serialize();
            FString jsonFString = FString(UTF8_TO_TCHAR(jsonString.c_str()));

            // JSON Reader 생성
            TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(jsonFString);

            // FJsonObject 포인터 생성
            TSharedPtr<FJsonObject> JsonObject = MakeShareable(new FJsonObject());

            if(FJsonSerializer::Deserialize(Reader, JsonObject) && JsonObject.IsValid())
            {
                Delegate.Execute(Result, static_cast<EHiveEngagementEventType>(engagementEventType), static_cast<EHiveEngagementEventState>(engagementEventState), JsonObject);
            }
            else
            {
                HIVE_LOG_WARNING(TEXT("deserialize error."));
                Delegate.Execute(Result, static_cast<EHiveEngagementEventType>(engagementEventType), static_cast<EHiveEngagementEventState>(engagementEventState), JsonObject);
            }
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePromotionImpl::ShowUAShare(const FString& InviteMessage, const FString& InviteLink, const FHivePromotionOnUAShareDelegate& Delegate)
{
    std::string StrInviteMessage(TCHAR_TO_UTF8(*InviteMessage));
    std::string StrInviteLink(TCHAR_TO_UTF8(*InviteLink));
    hive::Promotion::showUAShare(StrInviteMessage, StrInviteLink, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
            {
                FHiveResultAPI Result(result);

                Delegate.Execute(Result);
            }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    }); 
}

void IHivePromotionImpl::UpdatePromotionData()
{
    hive::Promotion::updatePromotionData();
}

void IHivePromotionImpl::GetAppInvitationSenderInfo(const FHivePromotionOnAppInvitationSenderInfoDelegate& Delegate)
{
    hive::Promotion::getAppInvitationSenderInfo([Delegate](hive::ResultAPI const & result, hive::AppInvitationSenderInfo const & senderInfo) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHiveAppInvitationSenderInfo AppInvitationSenderInfo(senderInfo);

            Delegate.Execute(Result, AppInvitationSenderInfo);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePromotionImpl::HandleCEFImeForPromotionEvent(hive::PromotionEventType Type)
{
    switch(Type)
    {
        case hive::PromotionEventType::OPEN:
            HIVESDKCEFImeEnable();
            break;
        case hive::PromotionEventType::CLOSE:
            HIVESDKCEFImeDisable();
            break;
        default:
            break;
    }
}
