/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveProviderAppleImpl.h"
#include "HiveUELogger.h"

void IHiveProviderAppleImpl::ReportScore(const FString& Score, const FString& LeaderboardIdentifier, const FHiveProviderAppleOnReportLeaderboard& Delegate)
{
    std::string StrScore(TCHAR_TO_UTF8(*Score));
    std::string StrLeaderboardIdentifier(TCHAR_TO_UTF8(*LeaderboardIdentifier));

    hive::ProviderApple::reportScore(StrScore, StrLeaderboardIdentifier, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderAppleImpl::ShowLeaderboard(const FHiveProviderAppleOnShowLeaderboard& Delegate)
{
    hive::ProviderApple::showLeaderboard([Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderAppleImpl::LoadAchievements(const FHiveProviderAppleOnLoadAchievements& Delegate)
{
    hive::ProviderApple::loadAchievements([Delegate](hive::ResultAPI const & result, std::vector<hive::ProviderAppleAchievement> const & achievements) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            TArray<FHiveProviderAppleAchievement> Achievements;

            if (achievements.size() > 0)
            {
                Achievements.Reserve(achievements.size());
                for (const auto& achievement : achievements)
                {
                    FHiveProviderAppleAchievement Achievement(achievement);
                    Achievements.Emplace(Achievement);
                }
            }

            Delegate.Execute(Result, Achievements);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderAppleImpl::ReportAchievement(const FString& Percent, bool ShowCompletionBanner, const FString& AchievementIdentifier, const FHiveProviderAppleOnReportAchievement& Delegate)
{
    std::string StrPercent(TCHAR_TO_UTF8(*Percent));
    std::string StrAchievementIdentifier(TCHAR_TO_UTF8(*AchievementIdentifier));
    hive::ProviderApple::reportAchievement(StrPercent, ShowCompletionBanner, StrAchievementIdentifier, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderAppleImpl::ShowAchievements(const FHiveProviderAppleOnShowAchievement& Delegate)
{
    hive::ProviderApple::showAchievements([Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderAppleImpl::ResetAchievements(const FHiveProviderAppleOnResetAchievement& Delegate)
{
    hive::ProviderApple::resetAchievements([Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}
