/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HiveProviderGoogleImpl.h"
#include "HiveUELogger.h"

void IHiveProviderGoogleImpl::AchievementsReveal(const FString& AchievementId, const FHiveProviderGoogleOnAchievementsDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::ProviderGoogle::achievementsReveal(StrAchievementId, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::AchievementsUnlock(const FString& AchievementId, const FHiveProviderGoogleOnAchievementsDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::ProviderGoogle::achievementsUnlock(StrAchievementId, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::AchievementsIncrement(const FString& AchievementId, int32 Value, const FHiveProviderGoogleOnAchievementsDelegate& Delegate)
{
    std::string StrAchievementId(TCHAR_TO_UTF8(*AchievementId));
    hive::ProviderGoogle::achievementsIncrement(StrAchievementId, Value, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::ShowAchievements(const FHiveProviderGoogleOnAchievementsDelegate& Delegate)
{
    hive::ProviderGoogle::showAchievements([Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::LeaderboardsSubmitScore(const FString& LeaderboardId, int64 Score, const FHiveProviderGoogleOnLeaderboardsDelegate& Delegate)
{
    std::string StrLeaderboardId(TCHAR_TO_UTF8(*LeaderboardId));
    hive::ProviderGoogle::leaderboardsSubmitScore(StrLeaderboardId, Score, [Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::ShowLeaderboard(const FHiveProviderGoogleOnLeaderboardsDelegate& Delegate)
{
    hive::ProviderGoogle::showLeaderboard([Delegate](hive::ResultAPI const & result) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            Delegate.Execute(Result);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHiveProviderGoogleImpl::GetGooglePlayerId(const FHiveProviderGoogleOnGooglePlayerIdDelegate& Delegate)
{
    hive::ProviderGoogle::getGooglePlayerId([Delegate](hive::ResultAPI const & result, std::string const & googlePlayerId, std::string const & authCode) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);
            FString GooglePlayerId = FString(UTF8_TO_TCHAR(googlePlayerId.c_str()));
            FString AuthCode = FString(UTF8_TO_TCHAR(authCode.c_str()));
            Delegate.Execute(Result, GooglePlayerId, AuthCode);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}