/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Impl/HivePushImpl.h"
#include "HiveUELogger.h"

void IHivePushImpl::GetRemotePush(const FHivePushOnRemotePushDelegate& Delegate)
{
    hive::Push::getRemotePush([Delegate](hive::ResultAPI const & result, hive::RemotePush const & remotePush) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHiveRemotePush RemotePush(remotePush);

            Delegate.Execute(Result, RemotePush);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePushImpl::SetRemotePush(const FHiveRemotePush& RemotePush, const FHivePushOnRemotePushDelegate& Delegate)
{
    bool isAgreeNotice = RemotePush.IsAgreeNotice;
    bool isAgreeNight = RemotePush.IsAgreeNight;
    hive::RemotePush remotePush(isAgreeNotice, isAgreeNight);

    hive::Push::setRemotePush(remotePush, [Delegate](hive::ResultAPI const & result, hive::RemotePush const & remotePush) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHiveRemotePush RemotePush(remotePush);

            Delegate.Execute(Result, RemotePush);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePushImpl::RegisterLocalPush(const FHiveLocalPush& LocalPush, const FHivePushOnLocalPushDelegate& Delegate)
{
    hive::LocalPush localPush;
    localPush.noticeId  = LocalPush.NoticeId;
    localPush.title     = TCHAR_TO_UTF8(*LocalPush.Title);
    localPush.msg       = TCHAR_TO_UTF8(*LocalPush.Msg);
    localPush.after     = LocalPush.After;
    localPush.groupId   = TCHAR_TO_UTF8(*LocalPush.GroupId);
    localPush.bigmsg    = TCHAR_TO_UTF8(*LocalPush.Bigmsg);
    localPush.ticker    = TCHAR_TO_UTF8(*LocalPush.Ticker);
    localPush.type      = TCHAR_TO_UTF8(*LocalPush.Type);
    localPush.icon      = TCHAR_TO_UTF8(*LocalPush.Icon);
    localPush.sound     = TCHAR_TO_UTF8(*LocalPush.Sound);
    localPush.active    = TCHAR_TO_UTF8(*LocalPush.Active);
    localPush.broadcastAction   = TCHAR_TO_UTF8(*LocalPush.BroadcastAction);
    localPush.buckettype    = LocalPush.BucketType;
    localPush.bucketsize    = LocalPush.BucketSize;
    localPush.bigpicture    = TCHAR_TO_UTF8(*LocalPush.BigPicture);
    localPush.icon_color    = TCHAR_TO_UTF8(*LocalPush.IconColor);

    hive::Push::registerLocalPush(localPush, [Delegate](hive::ResultAPI const & result, hive::LocalPush const & localPush) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHiveLocalPush LocalPush(localPush);

            Delegate.Execute(Result, LocalPush);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePushImpl::UnregisterLocalPush(int32 NoticeId)
{
    hive::Push::unregisterLocalPush(NoticeId);
}

void IHivePushImpl::UnregisterLocalPushes(TArray<int32> NoticeIds)
{
    std::vector<int> noticeIDs;
    for (int32 noticeId : NoticeIds)
    {
        noticeIDs.push_back(noticeId);
    }

    hive::Push::unregisterLocalPushes(noticeIDs);
}

void IHivePushImpl::UnregisterAllLocalPushes()
{
    hive::Push::unregisterAllLocalPushes();
}

void IHivePushImpl::SetForegroundPush(const FHivePushSetting& Setting, const FHivePushOnPushSettingDelegate& Delegate)
{
    bool useForegroundRemotePush = Setting.UseForegroundRemotePush;
    bool useForegroundLocalPush = Setting.UseForegroundLocalPush;
    hive::PushSetting pushSetting(useForegroundRemotePush, useForegroundLocalPush);
    hive::Push::setForegroundPush(pushSetting, [Delegate](hive::ResultAPI const &result, hive::PushSetting const &pushSetting) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHivePushSetting PushSetting(pushSetting);

            Delegate.Execute(Result, PushSetting);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePushImpl::GetForegroundPush(const FHivePushOnPushSettingDelegate& Delegate)
{
    hive::Push::getForegroundPush([Delegate](hive::ResultAPI const &result, hive::PushSetting const &pushSetting) {
        if (Delegate.IsBound())
        {
            FHiveResultAPI Result(result);

            FHivePushSetting PushSetting(pushSetting);

            Delegate.Execute(Result, PushSetting);
        }
        else
        {
            HIVE_LOG_WARNING(TEXT("Delegate is not bounded."));
        }
    });
}

void IHivePushImpl::RequestPushPermission()
{
    hive::Push::requestPushPermission();
}
