/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Types/HivePromotionTypes.h"

FString GetNameFromEHivePromotionType(const EHivePromotionType& PromotionType)
{
    switch(PromotionType) {
        case EHivePromotionType::BANNER_LEGACY: return FString(TEXT("BANNER_LEGACY"));
        case EHivePromotionType::BANNER:        return FString(TEXT("BANNER"));
        case EHivePromotionType::NEWS:          return FString(TEXT("NEWS"));
        case EHivePromotionType::NOTICE:        return FString(TEXT("NOTICE"));
    }
    return FString(TEXT("BANNER"));
}

EHivePromotionType GetEHivePromotionTypeFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionType> EHivePromotionTypeMap = {
        {TEXT("BANNER_LEGACY"), EHivePromotionType::BANNER_LEGACY},
        {TEXT("BANNER"),        EHivePromotionType::BANNER},
        {TEXT("NEWS"),          EHivePromotionType::NEWS},
        {TEXT("NOTICE"),        EHivePromotionType::NOTICE}
    };

    if (const EHivePromotionType* PromotionTypePtr = EHivePromotionTypeMap.Find(Name))
    {
        return *PromotionTypePtr;
    }
    return EHivePromotionType::BANNER;
}

FString GetNameFromEHivePromotionEventType(const EHivePromotionEventType& PromotionEventType)
{
    switch(PromotionEventType) {
        case EHivePromotionEventType::OPEN:             return FString(TEXT("OPEN"));
        case EHivePromotionEventType::CLOSE:            return FString(TEXT("CLOSE"));
        case EHivePromotionEventType::START_PLAYBACK:   return FString(TEXT("START_PLAYBACK"));
        case EHivePromotionEventType::FINISH_PLAYBACK:  return FString(TEXT("FINISH_PLAYBACK"));
        case EHivePromotionEventType::EXIT:             return FString(TEXT("EXIT"));
        case EHivePromotionEventType::GOBACK:           return FString(TEXT("GOBACK"));
    }
    return FString(TEXT("CLOSE"));
}

EHivePromotionEventType GetEHivePromotionEventTypeFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionEventType> EHivePromotionEventTypeMap = {
        {TEXT("OPEN"),              EHivePromotionEventType::OPEN},
        {TEXT("CLOSE"),             EHivePromotionEventType::CLOSE},
        {TEXT("START_PLAYBACK"),    EHivePromotionEventType::START_PLAYBACK},
        {TEXT("FINISH_PLAYBACK"),   EHivePromotionEventType::FINISH_PLAYBACK},
        {TEXT("EXIT"),              EHivePromotionEventType::EXIT},
        {TEXT("GOBACK"),            EHivePromotionEventType::GOBACK},
    };

    if (const EHivePromotionEventType* PromotionEventTypePtr = EHivePromotionEventTypeMap.Find(Name))
    {
        return *PromotionEventTypePtr;
    }
    return EHivePromotionEventType::CLOSE;
}

FString GetNameFromEHivePromotionCustomType(const EHivePromotionCustomType& PromotionCustomType)
{
    switch(PromotionCustomType) {
        case EHivePromotionCustomType::VIEW:    return FString(TEXT("VIEW"));
        case EHivePromotionCustomType::BOARD:   return FString(TEXT("BOARD"));
        case EHivePromotionCustomType::SPOT:    return FString(TEXT("SPOT"));
        case EHivePromotionCustomType::DIRECT:  return FString(TEXT("DIRECT"));
    }
    return FString(TEXT("VIEW"));
}

EHivePromotionCustomType GetEHivePromotionCustomTypeFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionCustomType> EHivePromotionCustomTypeMap = {
        {TEXT("VIEW"),  EHivePromotionCustomType::VIEW},
        {TEXT("BOARD"), EHivePromotionCustomType::BOARD},
        {TEXT("SPOT"),  EHivePromotionCustomType::SPOT},
        {TEXT("DIRECT"),EHivePromotionCustomType::DIRECT}
    };

    if (const EHivePromotionCustomType* PromotionCustomTypePtr = EHivePromotionCustomTypeMap.Find(Name))
    {
        return *PromotionCustomTypePtr;
    }
    return EHivePromotionCustomType::VIEW;
}

FString GetNameFromEHiveOfferwallState(const EHiveOfferwallState& OfferwallState)
{
    switch(OfferwallState) {
        case EHiveOfferwallState::ENABLED:    return FString(TEXT("ENABLED"));
        case EHiveOfferwallState::DISABLED:   return FString(TEXT("DISABLED"));
        case EHiveOfferwallState::UNKNOWN:    return FString(TEXT("UNKNOWN"));
    }
    return FString(TEXT("UNKNOWN"));
}

EHiveOfferwallState GetEHiveOfferwallStateFromName(const FString& Name)
{
    static TMap<FString, EHiveOfferwallState> EHiveOfferwallStateMap = {
        {TEXT("ENABLED"),  EHiveOfferwallState::ENABLED},
        {TEXT("DISABLED"), EHiveOfferwallState::DISABLED},
        {TEXT("UNKNOWN"),  EHiveOfferwallState::UNKNOWN}
    };

    if (const EHiveOfferwallState* OfferwallStatePtr = EHiveOfferwallStateMap.Find(Name))
    {
        return *OfferwallStatePtr;
    }
    return EHiveOfferwallState::UNKNOWN;
}

FString GetNameFromEHivePromotionBadgeTarget(const EHivePromotionBadgeTarget& PromotionBadgeTarget)
{
    switch(PromotionBadgeTarget) {
        case EHivePromotionBadgeTarget::NEWS:        return FString(TEXT("NEWS"));
        case EHivePromotionBadgeTarget::NOTICE:      return FString(TEXT("NOTICE"));
        case EHivePromotionBadgeTarget::CUSTOMVIEW:  return FString(TEXT("CUSTOMVIEW"));
        case EHivePromotionBadgeTarget::CUSTOMBOARD: return FString(TEXT("CUSTOMBOARD"));
    }
    return FString(TEXT("NEWS"));
}

EHivePromotionBadgeTarget GetEHivePromotionBadgeTargetFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionBadgeTarget> EHivePromotionBadgeTargetMap = {
        {TEXT("NEWS"),      EHivePromotionBadgeTarget::NEWS},
        {TEXT("NOTICE"),    EHivePromotionBadgeTarget::NOTICE},
        {TEXT("CUSTOMVIEW"),EHivePromotionBadgeTarget::CUSTOMVIEW},
        {TEXT("CUSTOMBOARD"),EHivePromotionBadgeTarget::CUSTOMBOARD}
    };

    if (const EHivePromotionBadgeTarget* EHivePromotionBadgeTargetPtr = EHivePromotionBadgeTargetMap.Find(Name))
    {
        return *EHivePromotionBadgeTargetPtr;
    }
    return EHivePromotionBadgeTarget::NEWS;
}

FString GetNameFromEHivePromotionCampaignType(const EHivePromotionCampaignType& PromotionCampaignType)
{
    switch(PromotionCampaignType) {
        case EHivePromotionCampaignType::EVENT:     return FString(TEXT("EVENT"));
        case EHivePromotionCampaignType::NOTICE:    return FString(TEXT("NOTICE"));
        case EHivePromotionCampaignType::ALL:       return FString(TEXT("ALL"));
        case EHivePromotionCampaignType::CROSS:     return FString(TEXT("CROSS"));
    }
    return FString(TEXT("EVENT"));
}

EHivePromotionCampaignType GetEHivePromotionCampaignTypeFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionCampaignType> EHivePromotionCampaignTypeMap = {
        {TEXT("EVENT"),     EHivePromotionCampaignType::EVENT},
        {TEXT("NOTICE"),    EHivePromotionCampaignType::NOTICE},
        {TEXT("ALL"),       EHivePromotionCampaignType::ALL},
        {TEXT("CROSS"),     EHivePromotionCampaignType::CROSS}
    };

    if (const EHivePromotionCampaignType* EHivePromotionCampaignTypePtr = EHivePromotionCampaignTypeMap.Find(Name))
    {
        return *EHivePromotionCampaignTypePtr;
    }
    return EHivePromotionCampaignType::EVENT;
}

FString GetNameFromEHivePromotionBannerType(const EHivePromotionBannerType& PromotionBannerType)
{
    switch(PromotionBannerType) {
        case EHivePromotionBannerType::GREAT:       return FString(TEXT("GREAT"));
        case EHivePromotionBannerType::SMALL:       return FString(TEXT("SMALL"));
        case EHivePromotionBannerType::ROLLING:     return FString(TEXT("ROLLING"));
    }
    return FString(TEXT("GREAT"));
}

EHivePromotionBannerType GetEHivePromotionBannerTypeFromName(const FString& Name)
{
    static TMap<FString, EHivePromotionBannerType> EHivePromotionBannerTypeMap = {
        {TEXT("GREAT"),     EHivePromotionBannerType::GREAT},
        {TEXT("SMALL"),     EHivePromotionBannerType::SMALL},
        {TEXT("ROLLING"),   EHivePromotionBannerType::ROLLING}
    };

    if (const EHivePromotionBannerType* EHivePromotionBannerTypePtr = EHivePromotionBannerTypeMap.Find(Name))
    {
        return *EHivePromotionBannerTypePtr;
    }
    return EHivePromotionBannerType::GREAT;
}

FString GetNameFromEHiveEngagementEventType(const EHiveEngagementEventType& EngagementEventType)
{
    switch(EngagementEventType) {
        case EHiveEngagementEventType::EVENT_TYPE:          return FString(TEXT("EVENT_TYPE"));
        case EHiveEngagementEventType::PROMOTION_VIEW:      return FString(TEXT("PROMOTION_VIEW"));
        case EHiveEngagementEventType::OFFERWALL_VIEW:      return FString(TEXT("OFFERWALL_VIEW"));
        case EHiveEngagementEventType::USER_ACQUISITION:    return FString(TEXT("USER_ACQUISITION"));
        case EHiveEngagementEventType::COUPON:              return FString(TEXT("COUPON"));
        case EHiveEngagementEventType::AUTH_LOGIN_VIEW:     return FString(TEXT("AUTH_LOGIN_VIEW"));
        case EHiveEngagementEventType::SOCIAL_INQUIRY_VIEW: return FString(TEXT("SOCIAL_INQUIRY_VIEW"));
        case EHiveEngagementEventType::EVENT:               return FString(TEXT("EVENT"));
        case EHiveEngagementEventType::IAP_UPDATED:         return FString(TEXT("IAP_UPDATED"));
        case EHiveEngagementEventType::IAP_PURCHASE:        return FString(TEXT("IAP_PURCHASE"));
        case EHiveEngagementEventType::IAP_PROMOTE:         return FString(TEXT("IAP_PROMOTE"));
        case EHiveEngagementEventType::COMPANION:           return FString(TEXT("COMPANION"));
        case EHiveEngagementEventType::SOCIAL_MYINQUIRY_VIEW:   return FString(TEXT("SOCIAL_MYINQUIRY_VIEW"));
        case EHiveEngagementEventType::SOCIAL_PROFILE_VIEW:     return FString(TEXT("SOCIAL_PROFILE_VIEW"));
        case EHiveEngagementEventType::COMMUNITY_VIEW:          return FString(TEXT("COMMUNITY_VIEW"));
        case EHiveEngagementEventType::APPUPDATE_DOWNLOADED:    return FString(TEXT("APPUPDATE_DOWNLOADED"));
    }
    return FString(TEXT("EVENT_TYPE"));
}
EHiveEngagementEventType GetEHiveEngagementEventTypeFromName(const FString& Name)
{
    static TMap<FString, EHiveEngagementEventType> EHiveEngagementEventTypeMap = {
        {TEXT("EVENT_TYPE"),            EHiveEngagementEventType::EVENT_TYPE},
        {TEXT("PROMOTION_VIEW"),        EHiveEngagementEventType::PROMOTION_VIEW},
        {TEXT("OFFERWALL_VIEW"),        EHiveEngagementEventType::OFFERWALL_VIEW},
        {TEXT("USER_ACQUISITION"),      EHiveEngagementEventType::USER_ACQUISITION},
        {TEXT("COUPON"),                EHiveEngagementEventType::COUPON},
        {TEXT("AUTH_LOGIN_VIEW"),       EHiveEngagementEventType::AUTH_LOGIN_VIEW},
        {TEXT("SOCIAL_INQUIRY_VIEW"),   EHiveEngagementEventType::SOCIAL_INQUIRY_VIEW},
        {TEXT("EVENT"),                 EHiveEngagementEventType::EVENT},
        {TEXT("IAP_UPDATED"),           EHiveEngagementEventType::IAP_UPDATED},
        {TEXT("IAP_PURCHASE"),          EHiveEngagementEventType::IAP_PURCHASE},
        {TEXT("IAP_PROMOTE"),           EHiveEngagementEventType::IAP_PROMOTE},
        {TEXT("COMPANION"),             EHiveEngagementEventType::COMPANION},
        {TEXT("SOCIAL_MYINQUIRY_VIEW"), EHiveEngagementEventType::SOCIAL_MYINQUIRY_VIEW},
        {TEXT("SOCIAL_PROFILE_VIEW"),   EHiveEngagementEventType::SOCIAL_PROFILE_VIEW},
        {TEXT("COMMUNITY_VIEW"),        EHiveEngagementEventType::COMMUNITY_VIEW},
        {TEXT("APPUPDATE_DOWNLOADED"),  EHiveEngagementEventType::APPUPDATE_DOWNLOADED}
    };

    if (const EHiveEngagementEventType* EHiveEngagementEventTypePtr = EHiveEngagementEventTypeMap.Find(Name))
    {
        return *EHiveEngagementEventTypePtr;
    }
    return EHiveEngagementEventType::EVENT_TYPE;
}

FString GetNameFromEHiveEngagementEventState(const EHiveEngagementEventState& EngagementEventState)
{
    switch(EngagementEventState) {
        case EHiveEngagementEventState::BEGIN:          return FString(TEXT("BEGIN"));
        case EHiveEngagementEventState::FINISH:         return FString(TEXT("FINISH"));
        case EHiveEngagementEventState::EVENT_START:    return FString(TEXT("EVENT_START"));
        case EHiveEngagementEventState::EVENT_END:      return FString(TEXT("EVENT_END"));
    }
    return FString(TEXT("BEGIN"));
}
EHiveEngagementEventState GetEHiveEngagementEventStateFromName(const FString& Name)
{
    static TMap<FString, EHiveEngagementEventState> EHiveEngagementEventStateMap = {
        {TEXT("BEGIN"),         EHiveEngagementEventState::BEGIN},
        {TEXT("FINISH"),        EHiveEngagementEventState::FINISH},
        {TEXT("EVENT_START"),   EHiveEngagementEventState::EVENT_START},
        {TEXT("EVENT_END"),     EHiveEngagementEventState::EVENT_END},
    };

    if (const EHiveEngagementEventState* EHiveEngagementEventStatePtr = EHiveEngagementEventStateMap.Find(Name))
    {
        return *EHiveEngagementEventStatePtr;
    }
    return EHiveEngagementEventState::BEGIN;
}

FHivePromotionViewInfo::FHivePromotionViewInfo(const hive::PromotionViewInfo& ViewInfo)
: Url(UTF8_TO_TCHAR(ViewInfo.url.c_str()))
, PostString(UTF8_TO_TCHAR(ViewInfo.postString.c_str()))
{ }

FHivePromotionBadgeInfo::FHivePromotionBadgeInfo(const hive::PromotionBadgeInfo& BadgeInfo)
: Target(static_cast<EHivePromotionBadgeTarget>(BadgeInfo.target))
, ContentsKey(UTF8_TO_TCHAR(BadgeInfo.contentsKey.c_str()))
, BadgeType(UTF8_TO_TCHAR(BadgeInfo.badgeType.c_str()))
{ }

FHivePromotionBannerInfo::FHivePromotionBannerInfo(const hive::PromotionBannerInfo& BannerInfo)
: Pid(BannerInfo.pid)
, ImageUrl(UTF8_TO_TCHAR(BannerInfo.imageUrl.c_str()))
, LinkUrl(UTF8_TO_TCHAR(BannerInfo.linkUrl.c_str()))
, DisplayStartDate(UTF8_TO_TCHAR(BannerInfo.displayStartDate.c_str()))
, DisplayEndDate(UTF8_TO_TCHAR(BannerInfo.displayEndDate.c_str()))
, UtcStartDate(BannerInfo.utcStartDate)
, UtcEndDate(BannerInfo.utcEndDate)
, TypeLink(UTF8_TO_TCHAR(BannerInfo.typeLink.c_str()))
, TypeBanner(UTF8_TO_TCHAR(BannerInfo.typeBanner.c_str()))
, TypeCampaign(UTF8_TO_TCHAR(BannerInfo.typeCampaign.c_str()))
, InterworkData(UTF8_TO_TCHAR(BannerInfo.interworkData.c_str()))
{ }

FHiveAppInvitationCampaign::FHiveAppInvitationCampaign(const hive::AppInvitationCampaign& AppInvitationCampaign)
: Title(UTF8_TO_TCHAR(AppInvitationCampaign.title.c_str()))
, Description(UTF8_TO_TCHAR(AppInvitationCampaign.description.c_str()))
, ImageUrl(UTF8_TO_TCHAR(AppInvitationCampaign.imageUrl.c_str()))
, Order(AppInvitationCampaign.order)
, Count(AppInvitationCampaign.count)
, Limit(AppInvitationCampaign.limit)
, CampaignId(UTF8_TO_TCHAR(AppInvitationCampaign.campaignId.c_str()))
{
    FString ItemFString = FString(UTF8_TO_TCHAR(AppInvitationCampaign.item.serialize().c_str()));

    TSharedRef<TJsonReader<>> Reader = TJsonReaderFactory<>::Create(ItemFString);
    this->Item = MakeShareable(new FJsonObject());
    FJsonSerializer::Deserialize(Reader, this->Item);
}

FHiveAppInvitationCampaignStage::FHiveAppInvitationCampaignStage(const hive::AppInvitationCampaignStage& AppInvitationCampaignStage)
: FHiveAppInvitationCampaign(AppInvitationCampaignStage)
, GoalCount(AppInvitationCampaignStage.goalCount)
, GoalTotal(AppInvitationCampaignStage.goalTotal)
{ }

FHiveAppInvitationData::FHiveAppInvitationData(const hive::AppInvitationData& AppInvitationData)
: InviteCommonLink(UTF8_TO_TCHAR(AppInvitationData.inviteCommonLink.c_str()))
, InviteHiveMsgLink(UTF8_TO_TCHAR(AppInvitationData.inviteHivemsgLink.c_str()))
, InviteFacebookLink(UTF8_TO_TCHAR(AppInvitationData.inviteFacebookLink.c_str()))
, InviteMessage(UTF8_TO_TCHAR(AppInvitationData.inviteMessage.c_str()))
{
    // Set QrCode
    for(const auto& data : AppInvitationData.qrCode)
    {
        this->QrCodes.Add(static_cast<uint8>(data));
    }

    // Set EachCampaignList
    for(const auto& data : AppInvitationData.eachCampaignList)
    {
        this->EachCampaignList.Emplace(static_cast<FHiveAppInvitationCampaign>(data));
    }

    // Set StageCampaignList
    for(const auto& data : AppInvitationData.stageCampaignList)
    {
        this->StageCampaignList.Emplace(static_cast<FHiveAppInvitationCampaignStage>(data));
    }
}

FHiveAppInvitationSenderInfo::FHiveAppInvitationSenderInfo(const hive::AppInvitationSenderInfo& AppInvitationSenderInfo)
: Vid(UTF8_TO_TCHAR(AppInvitationSenderInfo.vid.c_str()))
{ }
