/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#include "Types/HivePushTypes.h"

FHiveRemotePush::FHiveRemotePush(bool bIsAgreeNotice, bool bIsAgreeNight)
{
    this->IsAgreeNotice = bIsAgreeNotice;
    this->IsAgreeNight = bIsAgreeNight;
}

FHiveRemotePush::FHiveRemotePush(const hive::RemotePush& RemotePush)
{
    this->IsAgreeNotice = RemotePush.isAgreeNotice;
    this->IsAgreeNight = RemotePush.isAgreeNight;
}

FHiveLocalPush::FHiveLocalPush(const hive::LocalPush& LocalPush)
: NoticeId(LocalPush.noticeId)
, Title(UTF8_TO_TCHAR(LocalPush.title.c_str()))
, Msg(UTF8_TO_TCHAR(LocalPush.msg.c_str()))
, After(LocalPush.after)
, GroupId(UTF8_TO_TCHAR(LocalPush.groupId.c_str()))
, Bigmsg(UTF8_TO_TCHAR(LocalPush.bigmsg.c_str()))
, Ticker(UTF8_TO_TCHAR(LocalPush.ticker.c_str()))
, Type(UTF8_TO_TCHAR(LocalPush.type.c_str()))
, Icon(UTF8_TO_TCHAR(LocalPush.icon.c_str()))
, Sound(UTF8_TO_TCHAR(LocalPush.sound.c_str()))
, Active(UTF8_TO_TCHAR(LocalPush.active.c_str()))
, BroadcastAction(UTF8_TO_TCHAR(LocalPush.broadcastAction.c_str()))
, BucketType(LocalPush.buckettype)
, BucketSize(LocalPush.bucketsize)
, BigPicture(UTF8_TO_TCHAR(LocalPush.bigpicture.c_str()))
, IconColor(UTF8_TO_TCHAR(LocalPush.icon_color.c_str()))
{ }

FHivePushSetting::FHivePushSetting(bool bUseForegroundRemotePushm, bool bUseForegroundLocalPush)
{
    this->UseForegroundRemotePush   = bUseForegroundRemotePushm;
    this->UseForegroundLocalPush    = bUseForegroundLocalPush;
}

FHivePushSetting::FHivePushSetting(const hive::PushSetting& Setting)
{
    this->UseForegroundRemotePush   = Setting.useForegroundRemotePush;
    this->UseForegroundLocalPush    = Setting.useForegroundLocalPush;
}
