// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once
#if PLATFORM_WINDOWS //UE

#include "CoreMinimal.h"
#include "GenericPlatform/ITextInputMethodSystem.h"

#include <vector>

typedef struct tagINPUT_RECT
{
	long    left;
	long    top;
	long    right;
	long    bottom;
} INPUT_RECT;

typedef struct tagINPUT_POINT
{
	long x;
	long y;
} INPUT_POINT;

class FCEFTextInputMethodContext : public ITextInputMethodContext,
	public TSharedFromThis<FCEFTextInputMethodContext>
{
public:
	
	FCEFTextInputMethodContext();

	void Enable();
	void Disable();

	virtual ~FCEFTextInputMethodContext();

	void AbortComposition();

	bool UpdateCachedGeometry(const FGeometry& AllottedGeometry);

	bool CEFCompositionRangeChanged(void* SelectionRange, const std::vector<INPUT_RECT>& CharacterBounds);

private:
	void ResetComposition();

public:
	
	// ITextInputMethodContext Interface
	virtual bool IsComposing() override;

private:
	virtual bool IsReadOnly() override;
	virtual uint32 GetTextLength() override;
	virtual void GetSelectionRange(uint32& BeginIndex, uint32& Length, ECaretPosition& CaretPosition) override;
	virtual void SetSelectionRange(const uint32 BeginIndex, const uint32 Length, const ECaretPosition CaretPosition) override;
	virtual void GetTextInRange(const uint32 BeginIndex, const uint32 Length, FString& OutString) override;
	virtual void SetTextInRange(const uint32 BeginIndex, const uint32 Length, const FString& InString) override;
	virtual int32 GetCharacterIndexFromPoint(const FVector2D& Point) override;
	virtual bool GetTextBounds(const uint32 BeginIndex, const uint32 Length, FVector2D& Position, FVector2D& Size) override;
	virtual void GetScreenBounds(FVector2D& Position, FVector2D& Size) override;
	virtual TSharedPtr<FGenericWindow> GetWindow() override;
	virtual void BeginComposition() override;
	virtual void UpdateCompositionRange(const int32 InBeginIndex, const uint32 InLength) override;
	virtual void EndComposition() override;

private:

	FGeometry CachedGeometry;
	bool bIsComposing;
	int32 CompositionBeginIndex;
	uint32 CompositionLength;

	uint32 SelectionRangeBeginIndex;
	uint32 SelectionRangeLength;
	ECaretPosition SelectionCaretPosition;

	std::vector<INPUT_RECT> CefCompositionBounds;
	FVector2D InputPos;

	FString CompositionString;

	bool bIsEnable;
};
#endif