/**
 * HiveSDK C++ 플러그인 인터페이스 헤더
 *
 * @ingroup hive
 * @author ryuvsken
 * @date		2016-2019
 * @copyright	Copyright © GAMEVIL COM2US PLATFORM Inc. All Right Reserved.
 */

#ifndef __HIVE_SDK_CPP_H__
#define  __HIVE_SDK_CPP_H__
/**
 * PLATFORM_WINDOWS, PLATFORM_MAC : defined only unreal engine.
 */
#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__) || defined(__NT__) || defined(PLATFORM_WINDOWS)
#define HIVE_PLUGIN_PLATFORM_WIN32
#elif defined(PLATFORM_MAC)
#define HIVE_PLUGIN_PLATFORM_MAC_OSX
#elif __APPLE__
#include <TargetConditionals.h>
#if TARGET_IPHONE_SIMULATOR
#define HIVE_PLUGIN_PLATFORM_IPHONE
#define HIVE_PLUGIN_PLATFORM_IPHONE_SIMULATOR
#elif TARGET_OS_IPHONE
#define HIVE_PLUGIN_PLATFORM_IPHONE
#elif TARGET_OS_MAC
#define HIVE_PLUGIN_PLATFORM_MAC_OSX
#else
#   error "Unknown Apple platform"
#endif
#elif __linux__
#define HIVE_PLUGIN_PLATFORM_LINUX
#elif __unix__ // all unices not caught above
#define HIVE_PLUGIN_PLATFORM_UNIX
#elif defined(_POSIX_VERSION)
    // POSIX
#define HIVE_PLUGIN_PLATFORM_POSIX
#else
#   error "Unknown compiler"
#endif

#include <functional>
#include "HIVE_ResultAPI.h"
#include "HIVE_Logger.h"
#include "HIVE_Configuration.h"
#include "HIVE_SocialHive.h"
#include "HIVE_SocialFacebook.h"
#include "HIVE_SocialGoogle.h"
#include "HIVE_Promotion.h"
#include "HIVE_Push.h"
#include "HIVE_Analytics.h"
#include "HIVE_PlatformHelper.h"
#include "HIVE_AuthV4.h"
#include "HIVE_IAPV4.h"
#include "HIVE_ProviderApple.h"
#include "HIVE_ProviderGoogle.h"
#include "HIVE_SocialV4.h"
#include "HIVE_DataStore.h"
#include "HIVE_MatchMaking.h"
#include "HIVE_Chat.h"

#endif		// __HIVE_SDK_CPP_H__



