//
//  HIVE_PermissionView.h
//  HIVE_SDK_Plugin
//
//  Created by paikjongman on 12/12/2018.
//

#ifndef HIVE_PermissionView_h
#define HIVE_PermissionView_h

#include "HIVE_ResultAPI.h"
#include <string>
#include <vector>
NS_HIVE_BEGIN

typedef enum {
    Camera = 1,
    Contacts = 2,
    Location = 3,
    Microphone = 4,
    Phone = 5,
    Photo = 6,
    Push = 7,
    Storage = 8,
    Common = 9,
    IDFA = 10,
    Other = 99999
} PermissionViewPermissionCategory;

class HIVESDK_DLLEXPORT PermissionViewUnitData {
public:
    PermissionViewUnitData();
    PermissionViewUnitData(picojson::value const& jsonParam);
    std::string title;       ///< UI에 노출되어야할 권한의 이름입니다.
    std::string contents;    ///< UI에 노출되어야할 권한의 내용입니다. 어떤 식으로 권한이 이용되는지 설명이 되어있습니다.
    PermissionViewPermissionCategory permissionCategory;
    std::string nativePermissionName;   ///< UI에는 노출하지 않는 권한의 이름입니다. 해당 이름으로 어떠한 권한을 이용하는지 판단 할 수 있습니다.
};

class HIVESDK_DLLEXPORT PermissionViewData {
public:
    PermissionViewData();
    PermissionViewData(picojson::value const& jsonParam);
    std::string contents;      ///< 권한 고지 팝업에 대한 설명입니다. 권한고지 팝업에 대한 설명이 들어있으므로 UI에 노출하여 주세요.
    std::vector<PermissionViewUnitData> permissions;    ///< 각 권한들에 대한 설명과 이름들이 들어있는 선형리스트 혹은 배열입니다. 데이터에 대해서는 PermissionViewUnitData를 참고하여 주세요. 리스트에 들어있는 데이터의 개수는 OS의 업데이트나 법령에 따라 추가적인 권한정보가 더 올수 있으니 UI 디자인은 여러개의 값이 들어 갈 수 있도록 변화에 능동적인 디자인이 되어야 합니다.
    std::vector<PermissionViewUnitData> commons;    ///< 공통에 해당하는 문구에 대한 설명과 이름들이 들어있는 선형리스트 혹은 배열입니다. 권한고지의 내용이 반드시 한 개 이상일 때만 commons데이터를 불러올 수 있습니다.
};
NS_HIVE_END		// namespace hive

#endif /* HIVE_PermissionView_h */
