/**
 * @file    HIVE_SocialGoogle.h
 *
 * @author  ryuvsken, nanomech
 * @date		2016-2019
 * @copyright	Copyright © GAMEVIL COM2US PLATFORM Inc. All Right Reserved.
 *  \brief		\copydoc SocialGoogle
 */

/**
 * @defgroup SocialGoogle
 * @ingroup Social
 * @addgroup SocialGoogle
 * @{
 */

#ifndef __HIVE_SOCIALGOOGLE_H__
#define  __HIVE_SOCIALGOOGLE_H__


#include "HIVE_ResultAPI.h"
#include "HIVE_SocialHive.h"


NS_HIVE_BEGIN


class ResultAPI;


/**
 * @ingroup SocialGoogle
 * @author		ryuvsken, nanomech
 * @since		4.0.0
 * \~korean HIVE 유저는 자신의 프로필 정보를 조회 하거나 수정할 수 있고 친구를 맺어서 친구와 함께 게임을 즐길 수 있는 소셜 게임 서비스를 제공한다.<br/>
 * HIVE 는 Facebook, 주소록 등의 외부 유저 정보를 이용하여 HIVE 친구를 맺고 목록의 동기화를 수행할 수 있다.<br/>
 * SocialGoogle 클래스는 Google Play Service 의 프로필 조회 기능을 제공한다.<br/><br/>
 *
 * \~english HIVE users can view and modify their profile information and provide a social game service where they can make friends and play games with their friends together.<br/>
 * HIVE can make HIVE friends and synchronize the list by using external user information such as Facebook and contacts on your device.<br/>
 * The SocialGoogle class provides Google Play Games profile.<br/><br/>
 */
class HIVESDK_DLLEXPORT SocialGoogle
{
public:

	class ProfileGooglePlay;




    /**
     * \~korean Google Play 프로필 정보 결과 통지
     *
     * @param result			API 호출 결과
     * @param profile			Google Play 프로필 정보
     * \~english Returns Google Play Games porfile
     *
     * @param result			API call rsult
     * @param profile			Google Play Games porfile
     * \~
     * @ingroup SocialGoogle
     */
	typedef std::function<void(ResultAPI const & result, std::vector<ProfileGooglePlay> const & profileList)> onProfileGoogle;




    /**
     * \~korean Google Play 유저의 프로필 정보를 얻어온다.
     *
     * @param listener	API 호출 결과 통지
     * \~english Request Google Play Games porfile.
     *
     * @param listener	API call result listener.
     * \~
     * @ingroup SocialGoogle
     */
	static void getMyProfile(onProfileGoogle listener);

    
    
    
	// Native 영역에서 호출된 요청을 처리하기 위한 플러그인 내부 코드
	static void executeEngine(picojson::value jsonParam);




    /**
     * \~korean GooglePlay Player 프로필 정보
     *
     * \~english Google Play Games Profile information
     * \~
     * @ingroup SocialGoogle
     * @author ryuvsken
     */
	class HIVESDK_DLLEXPORT ProfileGooglePlay {

	public:
		std::string playerId;			///< GooglePlay's PlayerId
		std::string playerName;			///< GooglePlay's DiaplayPlayerName


		ProfileGooglePlay();

		ProfileGooglePlay(std::string playerId, std::string playerName);

		ProfileGooglePlay(picojson::value jsonParam);

		picojson::object toJson() const;

		std::string toString() const;
	};
};


NS_HIVE_END		// namespace hive


#endif		// __HIVE_SOCIALGOOGLE_H__


/** @} */



