/**
 * @file        HiveSocialV4.h
 *
 *  @date        2025
 *  @copyright   Copyright © 2025 Com2uS Platform Corp. All Rights Reserved.
 *
 *  @defgroup    FHiveSocialV4
 * @{
 * \~korean  커뮤티니 페이지 노출, 사진 컨텐츠 공유 기능 제공<br/> 
 * \~english Community page exposure, photo content sharing function provided<br/><br/>
 */
#pragma once

#include "CoreMinimal.h"
#include "HiveInterface.h"
#include "Impl/HiveSocialV4Impl.h"

/**
 * \~korean  커뮤티니 페이지 노출, 사진 컨텐츠 공유 기능 제공<br/> 
 * \~english Community page exposure, photo content sharing function provided<br/><br/>
 * \~
 * @ingroup FHiveSocialV4
 */
class HIVESDK_API FHiveSocialV4 : public IHiveInterface<IHiveSocialV4Impl>
{
public:
    /**
     * \~korean 커뮤니티 페이지 요청 API
     *
     * @param ProviderType 요청 타입
     * @param Delegate showCommunity 결과 통지
     * \~english Request community page
     *
     * @param ProviderType request type
     * @param Delegate showCommunity result callback
     * \~
     *
     * @ingroup FHiveSocialV4
     */
    static void ShowCommunity(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnShowCommunityDelegate& Delegate);
    
    /**
     * \~korean 커뮤니티 페이지 요청 API
     *
     * @param ProviderType 요청 타입
     * @param ViewType 요청 UI 타입 (FullScreen, Frame)
     * @param Delegate showCommunity 결과 통지
     * \~english Request community page
     *
     * @param ProviderType request type
     * @param ViewType request UI type (FullScreen, Frame)
     * @param Delegate showCommunity result callback
     * \~
     *
     * @ingroup FHiveSocialV4
     */
    static void ShowCommunity(ESocialV4ProviderType ProviderType, ESocialV4ViewType ViewType, const FHiveSocialV4OnShowCommunityDelegate& Delegate);
    
    /**
     * \~korean 사진 공유 API
     *
     * @param ProviderType 요청 타입
     * @param Delegate sharePhotoContent 결과 통지
     * \~english Photo Share API.
     *
     * @param ProviderType request type
     * @param Delegate sharePhotoContent result callback
     * \~
     *
     * @ingroup FHiveSocialV4
     */
    static void SharePhoto(ESocialV4ProviderType ProviderType, const FHiveSocialV4OnSharePhotoDelegate& Delegate);
};