
/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"
#include "Types/HiveAuthV4Types.h"

DECLARE_DELEGATE_TwoParams(FHiveAuthV4HelperDelegate, const FHiveResultAPI& /* Result */, const TOptional<FHivePlayerInfo>& /* PlayerInfo */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4HelperOnDialogDismissDelegate, bool /* bIsDismiss */);

class HIVESDK_API IHiveAuthV4HelperImpl
{
public:
    virtual void SyncAccount(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void SignIn(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void SignOut(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void PlayerDelete(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void Connect(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void Disconnect(const EHiveProviderType& ProviderType, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void ShowAchievements(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void ShowLeaderboard(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void AchievementsReveal(const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void AchievementsUnlock(const FString& AchievementId, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void AchievementsIncrement(const FString& AchievementId, int32 value, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void LeaderboardsSubmitScore(const FString& LeaderboardId, int64 value, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void ShowConflict(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void ShowConflict(const FHiveConflictSingleViewData& ViewData, const FHiveAuthV4HelperDelegate& Delegate);
    virtual void SwitchAccount(const FHiveAuthV4HelperDelegate& Delegate);
    virtual void ResolveConflict(const FHiveAuthV4HelperDelegate& Delegate);
    virtual TArray<EHiveProviderType> GetIDPList();
    virtual void ShowGameCenterLoginCancelDialog(const FHiveAuthV4HelperOnDialogDismissDelegate& Delegate);
};
