/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HIVESDK.h"
#include "HiveResultAPI.h"
#include "Types/HiveAuthV4Types.h"

DECLARE_DELEGATE_FourParams(FHiveAuthV4OnSetupDelegate, const FHiveResultAPI& /* Result */, bool isAutoSignIn /* IsAutoSignIn */, const FString& /* Did */, const TArray<EHiveProviderType>& /* ProviderTypes */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnSignInDelegate, const FHiveResultAPI& /* Result */, const FHivePlayerInfo& /* PlayerInfo */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnSignOutDelegate, const FHiveResultAPI& /* Result */) ;
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnConnectDelegate, const FHiveResultAPI& /* Result */, const FHivePlayerInfo& /* ConflictPlayer */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnDisconnectDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnCheckProviderDelegate, const FHiveResultAPI& /* Result */, const FHiveProviderInfo& /* ProviderInfo */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnMaintenanceInfoDelegate, const FHiveResultAPI& /* Result */, const TArray<FHiveAuthV4MaintenanceInfo>& /* MaintenanceInfoList*/);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnShowInquiryDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnShowTermsDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnAdultConfirmDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnGetProfileDelegate, const FHiveResultAPI& /* Result */, const TArray<FHiveProfileInfo>& /* ProfileInfoList */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnShowProfileDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_ThreeParams(FHiveAuthV4OnGetProviderFriendsListDelegate, const FHiveResultAPI& /* Result */, const EHiveProviderType& /* ProviderType */, const ProviderFriendsMap& /* ProviderUserIdList */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnResolveConflictDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnAuthV4DialogDismissDelegate, bool /* bIsDismiss */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnShowDeviceManagementDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnGetHiveTalkPlusLoginTokenDelegate, const FHiveResultAPI& /* Result */, const FString& /* LoginToken */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnRefreshAccessTokenDelegate, const FHiveResultAPI& /* Result */, const FString& /* AccessToken */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnGetStoredPlayerIdListDelegate, const FHiveResultAPI& /* Result */, const TArray<int64>& /* PlayerIdList*/);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnStoreCurrentPlayerIdDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveAuthV4OnDeleteStoredPlayerIdDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnGetHashedDiDelegate, const FHiveResultAPI& /* Result */, const FString& /* HashedDi */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnIdentityVerificationDelegate, const FHiveResultAPI& /* Result */, const FHiveIdentity& /* Identity */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnGetAgeRangeDelegate, const FHiveResultAPI& /* Result */, const FHiveAuthV4AgeRange& /* AgeRange */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnShowAgeRangeUpdatePermissionDelegate, const FHiveResultAPI& /* Result */, const FHiveAuthV4AgeRange& /* AgeRange */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnCheckAgeGateDelegate, const FHiveResultAPI& /* Result */, const FString& /* DateOfBirth */);
DECLARE_DELEGATE_TwoParams(FHiveAuthV4OnSetAutoLoginEnabledDelegate, const FHiveResultAPI& /* Result */, bool /* Enabled */);

class HIVESDK_API IHiveAuthV4Impl
{
public:
    virtual void Setup(const FHiveAuthV4OnSetupDelegate& Delegate);
    virtual void SignIn(const EHiveProviderType& ProviderType, const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void SignInWithAuthKey(const FString& AuthKey, const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void SignOut(const FHiveAuthV4OnSignOutDelegate& Delegate);
    virtual void PlayerDelete(const FHiveAuthV4OnSignOutDelegate& Delegate);
    virtual void Connect(const EHiveProviderType& ProviderType, const FHiveAuthV4OnConnectDelegate& Delegate);
    virtual void Disconnect(const EHiveProviderType& ProviderType, const FHiveAuthV4OnDisconnectDelegate& Delegate);
    virtual void ConnectWithAuthKey(const FString& AuthKey, const FHiveAuthV4OnConnectDelegate& Delegate);
    virtual void DisconnectWithName(const FString& ProviderName,  const FHiveAuthV4OnDisconnectDelegate& Delegate);
    virtual void SelectConflict(int64 SelectedPlayerId, const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void ShowConflictSelection(const FHiveConflictViewData& ConflictViewData, const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void CheckProvider(const EHiveProviderType& ProviderType, const FHiveAuthV4OnCheckProviderDelegate& Delegate);
    virtual void CheckMaintenance(bool IsShow, const FHiveAuthV4OnMaintenanceInfoDelegate& Delegate);
    virtual void CheckBlacklist(bool IsShow, const FHiveAuthV4OnMaintenanceInfoDelegate& Delegate);
    virtual void SetProviderChangedListener(const FHiveAuthV4OnCheckProviderDelegate& Delegate);
    virtual void ShowSignIn(const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void ShowInquiry(const FHiveAuthV4OnShowInquiryDelegate& Delegate);
    virtual void ShowChatbotInquiry(const FString& AdditionalInfo, const FHiveAuthV4OnShowInquiryDelegate& Delegate);
    virtual void ShowMyInquiry(const FHiveAuthV4OnShowInquiryDelegate& Delegate);
    virtual void ShowTerms(const FHiveAuthV4OnShowTermsDelegate& Delegate);
    virtual void ShowAdultConfirm(const FHiveAuthV4OnAdultConfirmDelegate& Delegate);
    virtual void GetProfile(const TArray<int64> PlayerIdArray, const FHiveAuthV4OnGetProfileDelegate& Delegate);
    virtual void ShowProfile(int64 PlayerId, const FHiveAuthV4OnShowProfileDelegate& Delegate);
    virtual void ResetAgreement();
    virtual bool IsAutoSignIn();
    virtual TOptional<FHivePlayerInfo> GetPlayerInfo();
    virtual void GetProviderFriendsList(const EHiveProviderType& ProviderType, const FHiveAuthV4OnGetProviderFriendsListDelegate& Delegate);
    virtual void ResolveConflict(const FHiveAuthV4OnResolveConflictDelegate& Delegate);
    virtual void ShowGameCenterLoginCancelDialog(const FHiveAuthV4OnAuthV4DialogDismissDelegate& Delegate);
    virtual bool GetAgeGateU13();
    virtual void ShowDeviceManagement(const FHiveAuthV4OnShowDeviceManagementDelegate& Delegate);
    virtual void GetHiveTalkPlusLoginToken(const FHiveAuthV4OnGetHiveTalkPlusLoginTokenDelegate& Delegate);
    virtual void RefreshAccessToken(const FHiveAuthV4OnRefreshAccessTokenDelegate& Delegate);
    virtual void SignInWithStoredPlayerId(int64 PlayerId, bool useAutoSignIn, const FHiveAuthV4OnSignInDelegate& Delegate);
    virtual void GetStoredPlayerIdList(const FHiveAuthV4OnGetStoredPlayerIdListDelegate& Delegate);
    virtual void StoreCurrentPlayerId(const FHiveAuthV4OnStoreCurrentPlayerIdDelegate& Delegate);
    virtual void DeleteStoredPlayerId(int64 PlayerId, const FHiveAuthV4OnDeleteStoredPlayerIdDelegate& Delegate);
    virtual TOptional<FHiveParentalConsentInfo> GetParentalConsentInfo();
    virtual void GetHashedDi(const FHiveAuthV4OnGetHashedDiDelegate& Delegate);
    virtual void ShowIdentityVerification(const FHiveAuthV4OnIdentityVerificationDelegate& Delegate);
    virtual void GetAgeRange(const FHiveAuthV4OnGetAgeRangeDelegate& Delegate);
    virtual void ShowAgeRangeUpdatePermission(const FString& Description, const FHiveAuthV4OnShowAgeRangeUpdatePermissionDelegate& Delegate);
    virtual void CheckAgeGate(bool UseCloseButton, const FHiveAuthV4OnCheckAgeGateDelegate& Delegate);
    virtual void SetAutoLoginEnabled(bool enabled, const FHiveAuthV4OnSetAutoLoginEnabledDelegate& Delegate);

    /* @NOTSUPPORT
     * - void RequestPermissionViewData()
     */ 
};
