/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"
#include "Dom/JsonObject.h"
#include "Serialization/JsonReader.h"
#include "Serialization/JsonSerializer.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HIVESDK.h"
#include "HiveResultAPI.h"
#include "Types/HivePromotionTypes.h"


DECLARE_DELEGATE_TwoParams(FHivePromotionViewDelegate, const FHiveResultAPI& /* Result */, const EHivePromotionEventType& /* PromotionEventType */);
DECLARE_DELEGATE_TwoParams(FHivePromotionOnViewInfoDelegate, const FHiveResultAPI& /* Result */, const TArray<FHivePromotionViewInfo>& /* PromotionViewInfoList */);
DECLARE_DELEGATE_TwoParams(FHivePromotionOnBadgeInfoDelegate, const FHiveResultAPI& /* Result */, const TArray<FHivePromotionBadgeInfo>& /* PromotionBadgeInfoList */);
DECLARE_DELEGATE_TwoParams(FHivePromotionOnBannerInfoDelegate, const FHiveResultAPI& /* Result */, const TArray<FHivePromotionBannerInfo>& /* PromotionBannerInfoList */);
DECLARE_DELEGATE_TwoParams(FHivePromotionOnAppInvitationDataDelegate, const FHiveResultAPI& /* Result */, const FHiveAppInvitationData& /* AppInvitationData */);
DECLARE_DELEGATE_FourParams(FHivePromotionOnEngagementDelegate, const FHiveResultAPI& /* Result */, const EHiveEngagementEventType& /* EngagementEventType */, const EHiveEngagementEventState& /* EngagementEventState */, TSharedPtr<FJsonObject> /* Param */);
DECLARE_DELEGATE_OneParam(FHivePromotionOnUAShareDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_TwoParams(FHivePromotionOnAppInvitationSenderInfoDelegate, const FHiveResultAPI& /* Result */, const FHiveAppInvitationSenderInfo& /* AppInvitationSenderInfo */);


class HIVESDK_API IHivePromotionImpl
{
public:
    virtual void ShowPromotion(const EHivePromotionType& PromotionType, bool IsForced, const FHivePromotionViewDelegate& Delegate);
    virtual void ShowCustomContents(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionViewDelegate& Delegate);
    virtual void ShowCustomContentsOnGameWindow(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionViewDelegate& Delegate);
    virtual EHiveOfferwallState GetOfferwallState();
    virtual void ShowOfferwall(const FHivePromotionViewDelegate& Delegate);
    virtual void ShowNews(const FString& Menu, const TArray<int32>& GiftPidList, const FHivePromotionViewDelegate& Delegate);
    virtual void ShowNativeReview();
    virtual void ShowReview(const FHivePromotionViewDelegate& Delegate);
    virtual void ShowExit(const FHivePromotionViewDelegate& Delegate);
    virtual void GetViewInfo(const EHivePromotionCustomType& PromotionCustomType, const FString& ContentsKey, const FHivePromotionOnViewInfoDelegate& Delegate);
    virtual void GetBadgeInfo(const FHivePromotionOnBadgeInfoDelegate& Delegate);
    virtual void GetBannerInfo(const EHivePromotionCampaignType& CampaignType, const EHivePromotionBannerType& BannerType, const FHivePromotionOnBannerInfoDelegate& Delegate);
    virtual void GetBannerInfoString(const FString& CampaignString, const FString& BannerString, const FHivePromotionOnBannerInfoDelegate& Delegate);
    virtual void GetAppInvitationData(const FHivePromotionOnAppInvitationDataDelegate& Delegate);
    virtual void SetAdditionalInfo(const FString& AdditionalInfo);
    virtual TOptional<FHiveResultAPI> SetEngagementReady(bool IsReady);
    virtual bool ProcessURI(const FString& URI);
    virtual void SetEngagementDelegate(const FHivePromotionOnEngagementDelegate& Delegate);
    virtual void ShowUAShare(const FString& InviteMessage, const FString& InviteLink, const FHivePromotionOnUAShareDelegate& Delegate);
    virtual void UpdatePromotionData();
    virtual void GetAppInvitationSenderInfo(const FHivePromotionOnAppInvitationSenderInfoDelegate& Delegate);

private:
    void HandleCEFImeForPromotionEvent(hive::PromotionEventType Type);
};
