/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"
#include "HiveResultAPI.h"


DECLARE_DELEGATE_OneParam(FHiveProviderGoogleOnAchievementsDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_OneParam(FHiveProviderGoogleOnLeaderboardsDelegate, const FHiveResultAPI& /* Result */);
DECLARE_DELEGATE_ThreeParams(FHiveProviderGoogleOnGooglePlayerIdDelegate, const FHiveResultAPI& /* Result */, const FString& /* PlayerId */, const FString& /* AuthCode */)

class HIVESDK_API IHiveProviderGoogleImpl
{
public:
    /* Achievements */
    virtual void AchievementsReveal(const FString& AchievementId, const FHiveProviderGoogleOnAchievementsDelegate& Delegate);
    virtual void AchievementsUnlock(const FString& AchievementId, const FHiveProviderGoogleOnAchievementsDelegate& Delegate);
    virtual void AchievementsIncrement(const FString& AchievementId, int32 Value, const FHiveProviderGoogleOnAchievementsDelegate& Delegate);
    virtual void ShowAchievements(const FHiveProviderGoogleOnAchievementsDelegate& Delegate);

    /* Leaderboards */
    virtual void LeaderboardsSubmitScore(const FString& LeaderboardId, int64 Score, const FHiveProviderGoogleOnLeaderboardsDelegate& Delegate);
    virtual void ShowLeaderboard(const FHiveProviderGoogleOnLeaderboardsDelegate& Delegate);

    virtual void GetGooglePlayerId(const FHiveProviderGoogleOnGooglePlayerIdDelegate& Delegate);
};