/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"

/**
 * @brief 결제 마켓 형태
 *
 * @ingroup FHiveIAPV4
 */
enum class EHiveIAPV4Type
{
    NotSelected         = 0,
    AppleAppStore       = 1,
    GooglePlayStore     = 2,
    HIVELebi            = 3,
    OneStore            = 4,
    AmazonAppStore      = 5,
    SamsungGalaxyStore  = 6,
    HuaweiAppGallery    = 7,
    Funtap              = 8,
    OPPOAppMarket       = 9,
    VIVOAppStore        = 10,
    TencentMyapp        = 11,
    XiaomiAppStore      = 12,
    HuaweiAppGalleryChina = 13,
    FacebookCloudGame   = 14,
    HiveStore           = 15,
    Steam               = 16,
    Nowgg               = 17
};

/**
 * @brief HIVE IAP 백오피스에서 생성한 상품 정보<br/>
 * 마켓에 등록된 상품(Market Pid) 의 정보를 포함한다.
 *
 * @ingroup FHiveIAPV4
 */
class HIVESDK_API FHiveIAPV4Product
{
public:
    FString ProductType;
    FString MarketPid;
    FString Currency;
    double Price;
    FString DisplayPrice;
    FString Title;
    FString ProductDescription;
    FString OriginalMarketJson;
    FString DisplayOriginalPrice;
    double OriginalPrice;
    FString IconUrl;
    int32 CoinsReward;

    FHiveIAPV4Product() {};
    FHiveIAPV4Product(const hive::IAPV4Product& Product);
    virtual ~FHiveIAPV4Product() = default;
};

/**
 * Purchase 나 Restore API 에서 받을 수 있는 결과 정보.<br/>
 *
 * @ingroup FHiveIAPV4
 */
class HIVESDK_API FHiveIAPV4Receipt
{
public:
    EHiveIAPV4Type Type;
    FHiveIAPV4Product Product;
    FString IapPayload;
    FString HiveIapReceipt;
    FString BypassInfo;
    int32 Quantity;

    FHiveIAPV4Receipt() {};
    FHiveIAPV4Receipt(const hive::IAPV4Receipt& Receipt);
    virtual ~FHiveIAPV4Receipt() = default;
};

class HIVESDK_API FHiveIAPV4PurchaseParam
{
public:
    FString MarketPid;
    FString IapPayload;
    FString OldMarketPid;
    FString OfferToken;
    
    FHiveIAPV4PurchaseParam() {};
    FHiveIAPV4PurchaseParam(const hive::IAPV4PurchaseParam& Param);
    virtual ~FHiveIAPV4PurchaseParam() = default;
};

class HIVESDK_API FHiveIAPV4ConsumeInfoUserAgreement
{
public:
    bool DidAgree;
    int64 FirstAnsweredDate;
    int64 LastAnsweredDate;

    FHiveIAPV4ConsumeInfoUserAgreement();
    FHiveIAPV4ConsumeInfoUserAgreement(const hive::IAPV4ConsumeInfoUserAgreement& Info);
    virtual ~FHiveIAPV4ConsumeInfoUserAgreement() = default;
};

HIVESDK_API FString GetNameFromEHiveIAPV4Type(const EHiveIAPV4Type& IAPV4Type);
HIVESDK_API EHiveIAPV4Type GetEHiveIAPV4TypeFromName(const FString& Name);
