/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"

/**
 * @brief 로거 타입 형태
 *
 * @ingroup FHiveLogger
 */
enum class EHiveLogType
{
    Verbose = 0,
    Debug   = 1,
    Info    = 2,
    Warning = 3,
    Error   = 4,
    None    = 5
};

/**
 * @brief Log의 노출 정도를 조정하는 로그 필터<br/>
 * core와 service 로그의 필터를 각각 조정 가능하다.
 *
 * @ingroup FHiveLogger
 */
class HIVESDK_API FHiveLogFilter
{
public:
    EHiveLogType CoreLog = EHiveLogType::Verbose;
    EHiveLogType ServiceLog = EHiveLogType::Verbose;

    FHiveLogFilter() {};
    FHiveLogFilter(const hive::LogFilter& LogFilter);
    virtual ~FHiveLogFilter() = default;
};
