/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"

/**
* \~korean Apple GameCenter 업적 정보
* \~english Apple GameCenter achievements
* @ingroup FHiveProviderApple
*/
class HIVESDK_API FHiveProviderAppleAchievement
{
public:
    FString Identifier;     ///< \~korean 업적 identifier.  \~english  Achievement identifier.
    FString Percent;        ///< \~korean 업적 진행 percent value.  \~english  Achievement progress percent value.
    bool Completed;         ///< \~korean 업적 완료 여부.   \~english  Whether the achievement is complete.

    FHiveProviderAppleAchievement() {};
    FHiveProviderAppleAchievement(const hive::ProviderAppleAchievement& ViewInfo);
    virtual ~FHiveProviderAppleAchievement() = default;
};
