/* Copyright © 2024 Com2uS Platform Corp. All Rights Reserved. */
#pragma once

/* Unreal Engine Header */
#include "CoreMinimal.h"

/* Hive SDK Header */
#include "CPP/HIVE_CPP.h"

/**
 * \~korean 유저가 푸시를 수신하는 상태 정보
 *
 * \~english Information about the status of receiving push notification.
 * \~
 * @ingroup FHivePush
 */
class HIVESDK_API FHiveRemotePush
{
public:
    bool IsAgreeNotice  = false;    ///< \~korean 공지 푸시 수신 허용 여부 \~english Whether to receive announcement notification or not.
    bool IsAgreeNight = false;      ///< \~korean 야간 푸시 수신 허용 여부 \~english Whether to receive night-time notification or not. 

    FHiveRemotePush() {};
    FHiveRemotePush(bool bIsAgreeNotice, bool bIsAgreeNight);
    FHiveRemotePush(const hive::RemotePush& RemotePush);
    virtual ~FHiveRemotePush() = default;
};

/**
 * \~korean 로컬 푸시 등록 정보
 *
 * \~english Local push registration information.
 * \~
 * @ingroup FHivePush
 */
class HIVESDK_API FHiveLocalPush
{
public:
    int32 NoticeId = 0;             ///< \~korean 로컬 푸시 통지 ID \~english Local push notification ID
    FString Title;                  ///< \~korean 로컬 푸시 타이틀 \~english Local push title
    FString Msg;                    ///< \~korean 로컬 푸시 메시지 \~english Local push message
    int64 After = 0;                ///< \~korean 알림 시점 \~english Notification timer

    FString GroupId;                ///< \~korean 알림 그룹 ID \~english Notification Group ID

    FString Bigmsg;                 ///< \~korean 큰 글씨 \~english Big-text
    FString Ticker;                 ///< \~korean 메시지 티커 \~english Message Ticker
    FString Type;                   ///< \~korean 알림 형태 (bar, popup, toast 등) \~english Notification type (bar, popup, toast etc.)
    FString Icon;                   ///< \~korean 푸시 아이콘 \~english Push icon
    FString Sound;                  ///< \~korean 푸시 알림음 \~english Notification sound
    FString Active;                 ///< \~korean 수행할 동작 \~english Action to take

    FString BroadcastAction;
    int32 BucketType = 0;
    int32 BucketSize = 0;
    FString BigPicture;
    FString IconColor;

    FHiveLocalPush() {};
    FHiveLocalPush(const hive::LocalPush& LocalPush);
    virtual ~FHiveLocalPush() = default;
};

/**
 * \~korean 푸시 설정 정보
 *
 * \~english Push setting information
 * \~
 * @ingroup FHivePush
 */
class HIVESDK_API FHivePushSetting
{
public:
    bool UseForegroundRemotePush = false;       ///< \~korean 앱 활성화 시 리모트 푸시 수신 여부 \~english Whether to enable remote notification or not on the activated app.
    bool UseForegroundLocalPush = false;        ///< \~korean 앱 활성화 시 로컬 푸시 수신 여부 \~english Whether to enable local notification on the activated app.

    FHivePushSetting() {};
    FHivePushSetting(bool bUseForegroundRemotePushm, bool bUseForegroundLocalPush);
    FHivePushSetting(const hive::PushSetting& Setting);
    virtual ~FHivePushSetting() = default;
};
