// Copyright (C) 2024 Com2uS Platform Corporation

#include "HiveDependencyEditor.h"

#if WITH_EDITOR
#include "ISettingsModule.h"
#include "HiveDependencyAndroidSettings.h"
#include "HiveDependencyIOSSettings.h"
#endif


#define LOCTEXT_NAMESPACE "FHiveDependencyEditor"


void FHiveDependencyEditor::StartupModule()
{
#if WITH_EDITOR
    // This code will execute after your module is loaded into memory; the exact timing is specified in the .uplugin file per-module
    
    ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");

    if (SettingsModule != nullptr)
    {
        SettingsModule->RegisterSettings("Project", "Hive SDK", "Dependency - Android",
            LOCTEXT("DependencyEditorAndroidDisplayName", "Dependency - Android"),
            LOCTEXT("DependencyEdigtorAndroidDescription", "Set up the Android dependencies."),
            GetMutableDefault<UHiveDependencyAndroidSettings>());

        SettingsModule->RegisterSettings("Project", "Hive SDK", "Dependency - iOS",
            LOCTEXT("DependencyEditorIOSDisplayName", "Dependency - iOS"),
            LOCTEXT("DependencyEdigtorIOSDescription", "Set up the iOS dependencies."),
            GetMutableDefault<UHiveDependencyIOSSettings>());
    }
    
#endif
}

void FHiveDependencyEditor::ShutdownModule()
{
#if WITH_EDITOR
	// This function may be called during shutdown to clean up your module.  For modules that support dynamic reloading,
	// we call this function before unloading the module.
    
    ISettingsModule* SettingsModule = FModuleManager::GetModulePtr<ISettingsModule>("Settings");

    if (SettingsModule != nullptr)
    {
        SettingsModule->UnregisterSettings("Project", "Hive SDK", "Dependency - Android");
        SettingsModule->UnregisterSettings("Project", "Hive SDK", "Dependency - iOS");
    }

#endif
}

#undef LOCTEXT_NAMESPACE
	
IMPLEMENT_MODULE(FHiveDependencyEditor, HiveDependencyEditor)
