#include "CoreMinimal.h"
#include "Modules/ModuleInterface.h"

#if PLATFORM_WINDOWS
#include "HiveInterface.h"
#include "HiveAuthV4.h"
#include "HiveConfiguration.h"
#include "HiveIAPV4.h"

#include "WindowsHiveAuthV4Impl.h"
#include "WindowsHiveConfigurationImpl.h"
#include "WindowsHiveIAPV4Impl.h"
#endif

class FHiveSDKWindowsModule : public IModuleInterface
{
public:
    virtual void StartupModule() override
    {
#if PLATFORM_WINDOWS
        // Register the instance here if a separate Windows implementation is defined
        FHiveAuthV4::SetPlatformImpl(MakeShared<FWindowsHiveAuthV4Impl>());
        FHiveConfiguration::SetPlatformImpl(MakeShared<FWindowsHiveConfigurationImpl>());
        FHiveIAPV4::SetPlatformImpl(MakeShared<FWindowsHiveIAPV4Impl>());
        UE_LOG(LogTemp, Log, TEXT("HiveSDKWindows module loaded - Windows implementation registered"));
#endif
    }
    
    virtual void ShutdownModule() override {
#if PLATFORM_WINDOWS
        FHiveAuthV4::SetPlatformImpl(nullptr);
        FHiveConfiguration::SetPlatformImpl(nullptr);
        FHiveIAPV4::SetPlatformImpl(nullptr);
#endif
    }
};

IMPLEMENT_MODULE(FHiveSDKWindowsModule, HiveSDKWindows)