function clickIdpBtn(needTerms, index) {
    if (!needTerms) {
        location.href = 'hivesdk://ui?button=ok&selectedIndex=' + index.toString() + '&checkState=false';
        return;
    }
    if (getTermsCheckState()) {
        location.href = 'hivesdk://ui?button=ok&selectedIndex=' + index.toString() + '&checkState=' + getTermsCheckState();
    } else {
        const textWarn = document.querySelector('.txt_warn');
        textWarn.style.display = 'block';
    }
}
function getIdpButton(needTerms, name, img, index) {
    var t = document.querySelector('#idp_button');
    var clone = document.importNode(t.content, true);
    clone.querySelector('img').src = img;
    clone.querySelector('img').alt = name;

    const button = clone.querySelector('button');
    button.addEventListener('click', function () {
        clickIdpBtn(needTerms, index);
      });
    return clone;
}

/**
 * needTerms: 동의 노출여부 
 * idpList : idplist
 * idpList.name
 * idpList.img
 **/
function initIdpList(needTerms, autologin, idpList) {
    const agreeElements = document.querySelectorAll('.agree');
    if (!needTerms) {
        agreeElements[0].remove();
    }
    if (!autologin) {
        agreeElements[1].remove();
    }
    var index = 0;
    document.querySelector('.button_group').innerHTML = "";
    idpList.forEach(element => {
        var item = getIdpButton(needTerms, element.name, element.img, index);
        document.querySelector('.button_group').appendChild(item);
        index++;
    });

}
function getTermsCheckState() {
    const agreeCheck = document.querySelector('#checkAgree');
    return agreeCheck.checked;
}