let validEmailFormat = false;

function showUnavailableEmail() {
    $('#invalid_email_format').hide();
    $('#temporary_error').hide();
    $('#unavailable_email').show();
}

function showInvalidEmailFormat() {
    $('#unavailable_email').hide();
    $('#temporary_error').hide();
    $('#invalid_email_format').show();
}

function showTemporaryError() {
    $('#unavailable_email').hide();
    $('#invalid_email_format').hide();
    $('#temporary_error').show();
}

function checkEmailFormat(email) {
    return /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email);
}

function showErrorOnEmailTextbox(func) {
    let element = document.querySelector('#email_textbox');
    let errorInfoElement = $('.info_t');
    if (!element.classList.contains('error')) {
        element.classList.add('error');
    }

    func();
    if (!errorInfoElement.is(':visible')) {
        errorInfoElement.show();
    }
}

function updateEmailTextbox() {
    let element = document.querySelector('#email_textbox');
    let errorInfoElement = $('.info_t');
    if (validEmailFormat || element.value === '') {
        if (element.classList.contains('error')) {
            element.classList.remove('error');
        }
        errorInfoElement.hide();
    } else {
        showErrorOnEmailTextbox(showInvalidEmailFormat);
    }
}

function checkPhoneAuthEnable() {
    let enable = checkConditions();
    let element = document.querySelector('.btn_cert');
    if (enable) {
        if (!element.classList.contains('btn_on')) {
            element.classList.add('btn_on');
        }
        updateEmailTextbox();
        element.onclick = function() {
            location.href = "hivesdk://ui?button=guardian_auth";
        }
    } else {
        if (element.classList.contains('btn_on')) {
            element.classList.remove('btn_on');
        }
        element.onclick = null;
    }
}

window.addEventListener('load', function () {
    document.querySelector('#email_input').addEventListener('input', function () {
        validEmailFormat = checkEmailFormat(document.querySelector('#email_input').value);
        if (validEmailFormat) {
            $('.info_t').hide();
        }
        checkPhoneAuthEnable();
    });
    document.querySelector('#email_input').addEventListener('blur', function () {
        updateEmailTextbox();
    });
})