var okButtonEnable = false;
var okButtonEnableFromTimer = true;
function setEnablePhoneNumberButton(enable) {
    okButtonEnable = enable;
    var element = document.querySelector('.btn_send');
    if (okButtonEnableFromTimer && enable) {
        if (!element.classList.contains('btn_on')) {
            element.classList.remove('btn_off');
            element.classList.add('btn_on');
        }
    } else {
        if (!element.classList.contains('btn_off')) {
            element.classList.remove('btn_on');
            element.classList.add('btn_off');
        }
    }
}
function setOkButtonEnableFromTimer(enable) {
    okButtonEnableFromTimer = enable;
    if (!enable) {
        setEnablePhoneNumberButton(false);
    } else {
        setEnablePhoneNumberButton(document.querySelector('#input_phone').value.length > 0);
    }
}

function getCurrentCountryCode() {
    return document.querySelector('#country_code').textContent;
}

function getPhoneNumber() {
    return document.querySelector('#input_phone').value;
}

function onClickEnalbeOkButton() {
    if (okButtonEnable) {
        location.href = 'hivesdk://ui?button=send&country_code=' + getCurrentCountryCode() + '&phone_number=' + getPhoneNumber()
    }
}

function setPhoneNumberInputErrorMessage(message) {
    if (!document.querySelector('#phone_number_input_error').classList.contains('error_message')) {
        document.querySelector('#phone_number_input_error').classList.add('error_message');
    }
    document.querySelector('#phone_number_input_error_message').textContent = message;
}

var setPhoneNumberIsDone = false;
function setPhoneNumber(number) {
    //document.querySelector('.phone_number').textContent = number;
    setPhoneNumberIsDone = true;
}

function getVerificationCode() {
    return document.querySelector('#input_code').value;
}
function setErrorMessage(msg) {
    document.querySelector('#code_error').textContent = msg;
    if (!document.querySelector('.input_wrap').classList.contains('error_message')) {
        document.querySelector('.input_wrap').classList.add('error_message')
    }
}

function onVerifyButton() {
    if (verifyButtonEnable) {
        location.href = 'hivesdk://ui?button=ok&code=' + getVerificationCode();
    }
}
function sanitizeInput(inputValue) {
    const numericValue = inputValue.replace(/[^0-9]/g, '');
    return numericValue;
}

window.addEventListener('load', function () {
    setEnablePhoneNumberButton(okButtonEnable);
    document.querySelector('#input_phone').addEventListener('input', function () {
        if (okButtonEnableFromTimer) {
            setEnablePhoneNumberButton(document.querySelector('#input_phone').value.length > 0);
        }
    })

    remainTimeObject = document.querySelector('.remain_time');
    setEnableVerifyButton(verifyButtonEnable);
    document.querySelector('#input_code').addEventListener('input', function () {
        setEnableVerifyButton((setPhoneNumberIsDone && document.querySelector('#input_code').value.length > 0));
    })
	
  	const integerInput = document.getElementById('input_phone');
  	integerInput.addEventListener('input', function(event) {
  		const currentValue = event.target.value;
  		const sanitizedValue = sanitizeInput(currentValue);
  		event.target.value = sanitizedValue;
  	});	
})