function setDefaultCountryCode(countryCode) {
    document.querySelector('#country_code').textContent = countryCode;
}
function setCountryCodeList(list, defaultCountryCode) {
    setDefaultCountryCode(defaultCountryCode);
    var ul = document.querySelector('#country_code_list');
    ul.innerHTML = "";
    list.forEach(element => {
        var li = document.createElement('li');
        var btn = document.createElement('button');
        btn.type = "button"
        btn.textContent = element
        li.appendChild(btn);
        ul.appendChild(li);
        li.addEventListener('click', function (event) {
            console.log(event.target)
            setDefaultCountryCode(event.target.textContent)
        });
    });
}
var verifyButtonEnable = false;
function setEnableVerifyButton(enable) {
    verifyButtonEnable = enable;
    var element = document.querySelector('.btn_confirm');
    if (enable) {
        if (!element.classList.contains('btn_on')) {
            element.classList.remove('btn_off');
            element.classList.add('btn_on');
        }
    } else {
        if (!element.classList.contains('btn_off')) {
            element.classList.remove('btn_on');
            element.classList.add('btn_off');
        }
    }
}

var remainTimeObject;
function setRemainTime(time) {
    if (time <= 0) {
        remainTimeObject.textContent = remain_time_text;
        setErrorMessage(remain_error_text);
        return;
    }
    const m = Math.floor(time / 60)
    const s = Math.floor(time % 60)
    remainTimeObject.textContent = (m < 10 ? "0" : "") + m + ":" + (s < 10 ? "0" : "") + s;
}

var timerTime = 0;
var timeId;
var existTimer = false;
function startTimer(time) {
    timerTime = time
    if (existTimer) {
        clearInterval(timeId);
    }
    existTimer = true;
    setRemainTime(time);
    timeId = setInterval(function () {
        timerTime = timerTime - 1;
        setRemainTime(timerTime);
        if (timerTime <= 0) {
            clearInterval(timeId);
            existTimer = false;
        }
    }, 1000);
}

var resendButtonEnable = false;
function setEnableResend(enable) {
    resendButtonEnable = enable;
    var element = document.querySelector('.btn_resend');
    if (enable) {
        element.classList.remove('btn_off');
    } else {
        if (!element.classList.contains('btn_off')) {
            element.classList.remove('btn_on');
            element.classList.add('btn_off');
        }
    }
}
function onResendButton() {
    if (resendButtonEnable) {
        location.href = 'hivesdk://ui?button=resend';
    }
}
function numberCheckLengthOnInput(el, maxlength) {
    el.value = el.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');
    if (el.value.length > maxlength) {
        el.value = el.value.substr(0, maxlength);
    }
}

document.addEventListener("wheel", function (event) {
    if (document.activeElement.type === "number") {
        document.activeElement.blur();
    }
});