let lastClickTime = 0;
function preventDoubleClickHref(e, scheme) {
    const currentTime = new Date().getTime();
    const timeDiff = currentTime - lastClickTime;
    // ignore 2000ms event
    if (timeDiff < 2000) {
        e.preventDefault();
        return;
    }
    lastClickTime = currentTime;
    location.href = scheme;
}

const REPAY_BUTTON_STATE = {
    NeedRepay: 0,
    AlreadyRepay: 1,
    CantRepay: 2,

}
function getRepaymentButtonClassNameFromButtonState(state) {
    switch (state) {
        case REPAY_BUTTON_STATE.AlreadyRepay:
            return "btn_complete";
        case REPAY_BUTTON_STATE.CantRepay:
            return "btn_off";
        case REPAY_BUTTON_STATE.NeedRepay:
            return "btn_on";
        default:
            return "btn_on";
    }
}

function getRepaymentButtonTextFromButtonState(state, price) {
    switch (state) {
        case REPAY_BUTTON_STATE.AlreadyRepay:
            return repayment_already;
        case REPAY_BUTTON_STATE.CantRepay:
            return repayment_cant;
        case REPAY_BUTTON_STATE.NeedRepay:
            return price + " " + repayment_need;
        default:
            return price + " " + repayment_need;
    }
}

// ------ purchase --------
// itemList.id : 상품 id
// itemList.name : 상품 이름
// itemList.period : 기간
// itemList.price : 금액
// itemList.buttonStatus : 버튼 상태 (REPAY_BUTTON_STATE)
//re_pay_item 템플릿으로 부터 재결제 리스트 아이템을 생성한다.
function getRepayButtonItem(marketIndex, purchase, index) {
    var t = document.querySelector('#re_pay_item');
    var clone = document.importNode(t.content, true);
    clone.querySelector('.name').textContent = purchase.name;
    clone.querySelector('.period').textContent = purchase.period;
    clone.querySelector('button').textContent = getRepaymentButtonTextFromButtonState(purchase.buttonStatus, purchase.price);
    clone.querySelector('button').classList.add(getRepaymentButtonClassNameFromButtonState(purchase.buttonStatus));
    clone.querySelector('button').addEventListener('click', function () {
        if (purchase.buttonStatus == REPAY_BUTTON_STATE.NeedRepay) {
            preventDoubleClickHref(event, "hivesdk://ui?button=repay&market=" + marketIndex + "&index=" + index);
        }
    });
    return clone;
}
//spliter 템플릿으로 부터 spliter를 얻는다.
function getOtherMarketSpliter(name, count) {
    var t = document.querySelector('#re_pay_spliter');
    var clone = document.importNode(t.content, true);
    clone.querySelector('#other_pay_name').textContent = name;
    const countString = repayment_other_left;
    clone.querySelector('#other_pay_count').textContent = countString.replace("nn", count);
    return clone;
}

// 제결제 상품(nn/nn건) 형태로 만들기.
function getTitleRepaymentCasesString(remainCases, allCases) {
    var casesString = repayment_all_left
        .replace("nn", remainCases)
        .replace("mm", allCases);

    return repayment_title + casesString + "";
}

function setGuide(title, desc) {
    document.querySelector('#guide_title').innerHTML = title
    document.querySelector('#guide_description').innerHTML = desc
}
function setTitle(remainCases, allCases) {
    document.querySelector('#pay_title').textContent = getTitleRepaymentCasesString(remainCases, allCases);
}

const marketIndexFromPurchaseID = {};
const productIndexFromPurchaseID = {};
const productLiIndexFromPurchaseID = {};

function registerMarketIndex(id, refundIndex, marketIndex, productIndex, liIndex) {
    marketIndexFromPurchaseID[id] = marketIndex;
    productIndexFromPurchaseID[id] = productIndex;

    if (!productLiIndexFromPurchaseID[id]) {
        productLiIndexFromPurchaseID[id] = {};
    }
    productLiIndexFromPurchaseID[id][refundIndex] = liIndex;
}
function getMarketIndexFromId(id) {
    return marketIndexFromPurchaseID[id];
}
function getProductIndexFromId(id) {
    return productIndexFromPurchaseID[id];
}
function getProductLiIndexFromId(id, refundIndex) {
    return productLiIndexFromPurchaseID[id][refundIndex];
}

//재결제 리스트 설정
// itemList는 두가지 형식의 아이템이 들어올 수 있음. (itemList.type 에 따라 repay, spliter 두가지로 나뉜다.)å
// param : array
// itemList.isAvailableMarket : 구매 가능한 마켓인지 여부 bool
// itemList.marketName : 마켓 이름 string
// itemList.purchasesCount : purchase 개수 int
// itemList.purchases : Array (하위 purchase 참조, isAvailableMarket가 true일때만 유효) object
// ------ purchase --------
// itemList.id : 상품 id
// itemList.name : 상품 이름
// itemList.period : 기간
// itemList.price : 금액
// itemList.buttonStatus : 버튼 상태 (REPAY_BUTTON_STATE)
function setRepayItemList(itemList) {
    if (itemList.length <= 0) {
        return;
    }
    document.querySelector('.product').innerHTML = "";
    //첫번째 spliter는 무시
    var isFirstMarket = true;

    var marketIndex = 0;
    var liIndex = 0;
    itemList.forEach(element => {
        var index = 0;
        if (!isFirstMarket || element.isAvailableMarket == false) { // 구매 목록이 있는 첫번째 마켓은 마켓정보 노출안함.
            var item = getOtherMarketSpliter(element.marketName, element.purchasesCount);
            document.querySelector('.product').appendChild(item);
            liIndex++;
        }
        if (element.isAvailableMarket == true) {
            element.purchases.forEach(purchase => {
                var item = getRepayButtonItem(marketIndex, purchase, index);
                document.querySelector('.product').appendChild(item);
                registerMarketIndex(purchase.id, purchase.refundIndex, marketIndex, index, liIndex);
                index++;
                liIndex++;
            })
        }
        isFirstMarket = false;
        marketIndex++;
    });
}

// 구매 아이템 상태 업데이트 함수
// ------ purchase --------
// itemList.id : 상품 id
// itemList.name : 상품 이름
// itemList.period : 기간
// itemList.price : 금액
// itemList.buttonStatus : 버튼 상태 (REPAY_BUTTON_STATE)
function changePurchaseItemState(purchase) {
    const marketIndex = getMarketIndexFromId(purchase.id);
    const productIndex = getProductIndexFromId(purchase.id);
    const liIndex = getProductLiIndexFromId(purchase.id, purchase.refundIndex); // 추가한 인덱스 구하기 setRepayItemList에서 추가한 순서를 구할 수 있다.

    var purchaseList = document.querySelector('.product')
    purchaseList.replaceChild(getRepayButtonItem(marketIndex, purchase, productIndex), purchaseList.children[liIndex]);
}
function setCSCode(code) {
    document.querySelector('.cscode').textContent = "CS Code: " + code;
}
var gameStartEnabled = false;
function setGameStartButtonEnable(enable) {
    gameStartEnabled = enable;
    if (enable) {
        document.querySelector('.game_start').classList.add('btn_on')
        document.querySelector('.game_start').classList.remove('btn_off')
    } else {
        document.querySelector('.game_start').classList.add('btn_off')
        document.querySelector('.game_start').classList.remove('btn_on')
    }
}
function onCustomerCenter() {
    location.href = "hivesdk://ui?button=go_customer";
}
function onStartGame() {
    if (gameStartEnabled) {
        location.href = "hivesdk://ui?button=game_start";
    }
}
function onRefreshList() {
    location.href = "hivesdk://ui?button=refresh_list";
}