/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */

#include "ChannelSelectView.h"

void UChannelSelectView::PopulateChannelList()
{
    
    // 기존 목록 클리어
    ClearChannelList();
    
    // 채널 아이템 추가
    for (const FHiveChannel& Channel : CachedChannels)
    {
        FString ChannelType = "UNKNOWN";
        switch (Channel.type)
        {
            case EHiveChannelType::PUBLIC:
                ChannelType = "PUBLIC";
                break;
            case EHiveChannelType::PRIVATE:
                ChannelType = "PRIVATE";
                break;
            case EHiveChannelType::GROUP:
                ChannelType = "GROUP";
                break;
        }
        
        AddChannelItem(Channel.channelId, Channel.channelName, ChannelType, Channel.memberCount);
    }
}

void UChannelSelectView::OnSelectButtonClicked()
{
    if (!SelectedChannelId.IsEmpty() && OnChannelSelectedDelegate.IsBound())
    {
        OnChannelSelectedDelegate.Execute(SelectedChannelId);
    }
    RemoveFromParent();
}

void UChannelSelectView::OnCancelButtonClicked()
{
    if (OnCancelDelegate.IsBound())
    {
        OnCancelDelegate.Execute();
    }
    RemoveFromParent();
}

void UChannelSelectView::OnChannelItemClicked(const FString& ChannelId)
{
    SelectedChannelId = ChannelId;
}