/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "HiveChat.h"
#include "Types/HiveChatTypes.h"
#include "ChannelSelectView.generated.h"

DECLARE_DELEGATE_OneParam(FOnChannelSelected, FString /* ChannelId */);
DECLARE_DELEGATE(FOnChannelSelectCancel);

/**
 * 채널 선택 UI 위젯
 */
UCLASS()
class HIVESDKV4TESTER_API UChannelSelectView : public UUserWidget
{
    GENERATED_BODY()

public:
    // 채널 목록 표시
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void PopulateChannelList();

    // 선택된 채널 ID 가져오기
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ChannelSelect")
    FString GetSelectedChannelId() const { return SelectedChannelId; }

    // Select 버튼 클릭
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void OnSelectButtonClicked();

    // Cancel 버튼 클릭
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void OnCancelButtonClicked();

    // 채널 아이템 클릭
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void OnChannelItemClicked(const FString& ChannelId);

    // 델리게이트
    FOnChannelSelected OnChannelSelectedDelegate;
    FOnChannelSelectCancel OnCancelDelegate;
    
    // 채널 데이터 설정 (C++에서만 사용)
    void SetChannels(const TArray<FHiveChannel>& Channels) { CachedChannels = Channels; }

protected:
    // Blueprint에서 구현할 함수들
    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void ClearChannelList();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ChannelSelect")
    void AddChannelItem(const FString& ChannelId, const FString& ChannelName, const FString& ChannelType, int32 MemberCount);

private:
    UPROPERTY()
    FString SelectedChannelId;

    // UPROPERTY 제거 - 직접 메모리 관리
    TArray<FHiveChannel> CachedChannels;
};