/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */

#include "ChatDataManager.h"

UChatDataManager* UChatDataManager::Instance = nullptr;

UChatDataManager* UChatDataManager::GetInstance()
{
    if (!Instance)
    {
        Instance = NewObject<UChatDataManager>();
        Instance->AddToRoot(); // GC 방지
    }
    return Instance;
}

void UChatDataManager::SetCreateChannelChannelType(const FString& Value)
{
    CreateChannelChannelType = Value;
}

FString UChatDataManager::GetCreateChannelChannelTypeString() const
{
    return CreateChannelChannelType;
}

EHiveChannelType UChatDataManager::GetCreateChannelChannelType() const
{
    FString LowerValue = CreateChannelChannelType.ToLower();
    
    if (LowerValue == TEXT("public"))
    {
        return EHiveChannelType::PUBLIC;
    }
    else if (LowerValue == TEXT("private"))
    {
        return EHiveChannelType::PRIVATE;
    }
    else if (LowerValue == TEXT("group"))
    {
        return EHiveChannelType::GROUP;
    }
    else
    {
        return EHiveChannelType::UNKNOWN;
    }
}

void UChatDataManager::SetGetChannelsChannelType(const FString& Value)
{
    GetChannelsChannelType = Value;
}

FString UChatDataManager::GetGetChannelsChannelTypeString() const
{
    return GetChannelsChannelType;
}

EHiveChannelType UChatDataManager::GetGetChannelsChannelType() const
{
    FString LowerValue = GetChannelsChannelType.ToLower();
    
    if (LowerValue == TEXT("public"))
    {
        return EHiveChannelType::PUBLIC;
    }
    else if (LowerValue == TEXT("private"))
    {
        return EHiveChannelType::PRIVATE;
    }
    else if (LowerValue == TEXT("group"))
    {
        return EHiveChannelType::GROUP;
    }
    else if (LowerValue == TEXT("none") || LowerValue == TEXT("unknown"))
    {
        return EHiveChannelType::UNKNOWN;
    }
    else
    {
        return EHiveChannelType::UNKNOWN;
    }
}

void UChatDataManager::SetGetChannelsSortType(const FString& Value)
{
    GetChannelsSortType = Value;
}

FString UChatDataManager::GetGetChannelsSortTypeString() const
{
    return GetChannelsSortType;
}

EHiveSortType UChatDataManager::GetGetChannelsSortType() const
{
    FString LowerValue = GetChannelsSortType.ToLower();
    
    if (LowerValue == TEXT("channelid"))
    {
        return EHiveSortType::CHANNEL_ID;
    }
    else if (LowerValue == TEXT("channelname"))
    {
        return EHiveSortType::CHANNEL_NAME;
    }
    else if (LowerValue == TEXT("regtime"))
    {
        return EHiveSortType::REG_TIME;
    }
    else
    {
        return EHiveSortType::UNKNOWN;
    }
}

void UChatDataManager::SetReactionType(const FString& Value)
{
    ReactionType = Value;
}

FString UChatDataManager::GetReactionTypeString() const
{
    return ReactionType;
}

EHiveReactionType UChatDataManager::GetReactionType() const
{
    FString LowerValue = ReactionType.ToLower();
    
    if (LowerValue == TEXT("like"))
    {
        return EHiveReactionType::LIKE;
    }
    else if (LowerValue == TEXT("unknown"))
    {
        return EHiveReactionType::UNKNOWN;
    }
    else
    {
        // 기본값으로 LIKE 반환
        return EHiveReactionType::LIKE;
    }
}

// SendMessage Params
void UChatDataManager::SetSendMessageChannelId(const FString& Value)
{
    SendMessageChannelId = Value;
}

FString UChatDataManager::GetSendMessageChannelId() const
{
    return SendMessageChannelId;
}

void UChatDataManager::SetSendMessageMessage(const FString& Value)
{
    SendMessageMessage = Value;
}

FString UChatDataManager::GetSendMessageMessage() const
{
    return SendMessageMessage;
}

void UChatDataManager::SetSendMessageExtraData(const FString& Value)
{
    SendMessageExtraData = Value;
}

FString UChatDataManager::GetSendMessageExtraData() const
{
    return SendMessageExtraData;
}

void UChatDataManager::SetSendMessagePlayerId(int64 Value)
{
    SendMessagePlayerId = Value;
}

int64 UChatDataManager::GetSendMessagePlayerId() const
{
    return SendMessagePlayerId;
}

void UChatDataManager::SetSendMessageReplyMessageId(const FString& Value)
{
    SendMessageReplyMessageId = Value;
}

FString UChatDataManager::GetSendMessageReplyMessageId() const
{
    return SendMessageReplyMessageId;
}

void UChatDataManager::SetSendMessageMentionedPlayerIds(const FString& Value)
{
    SendMessageMentionedPlayerIds = Value;
}

FString UChatDataManager::GetSendMessageMentionedPlayerIds() const
{
    return SendMessageMentionedPlayerIds;
}

// Create Channel Params
void UChatDataManager::SetCreateChannelChannelId(const FString& Value)
{
    CreateChannelChannelId = Value;
}

FString UChatDataManager::GetCreateChannelChannelId() const
{
    return CreateChannelChannelId;
}

void UChatDataManager::SetCreateChannelPassword(const FString& Value)
{
    CreateChannelPassword = Value;
}

FString UChatDataManager::GetCreateChannelPassword() const
{
    return CreateChannelPassword;
}

void UChatDataManager::SetCreateChannelChannelName(const FString& Value)
{
    CreateChannelChannelName = Value;
}

FString UChatDataManager::GetCreateChannelChannelName() const
{
    return CreateChannelChannelName;
}

void UChatDataManager::SetCreateChannelMaxMemberCount(int32 Value)
{
    CreateChannelMaxMemberCount = Value;
}

int32 UChatDataManager::GetCreateChannelMaxMemberCount() const
{
    return CreateChannelMaxMemberCount;
}

void UChatDataManager::SetCreateChannelChatHistoryAllowed(bool Value)
{
    CreateChannelChatHistoryAllowed = Value;
}

bool UChatDataManager::GetCreateChannelChatHistoryAllowed() const
{
    return CreateChannelChatHistoryAllowed;
}

// Get Channels Params
void UChatDataManager::SetGetChannelsChannelId(const FString& Value)
{
    GetChannelsChannelId = Value;
}

FString UChatDataManager::GetGetChannelsChannelId() const
{
    return GetChannelsChannelId;
}

void UChatDataManager::SetGetChannelsChannelName(const FString& Value)
{
    GetChannelsChannelName = Value;
}

FString UChatDataManager::GetGetChannelsChannelName() const
{
    return GetChannelsChannelName;
}

void UChatDataManager::SetGetChannelsPageOrder(const FString& Value)
{
    GetChannelsPageOrder = Value;
}

FString UChatDataManager::GetGetChannelsPageOrder() const
{
    return GetChannelsPageOrder;
}

void UChatDataManager::SetGetChannelsPageSize(int32 Value)
{
    GetChannelsPageSize = Value;
}

int32 UChatDataManager::GetGetChannelsPageSize() const
{
    return GetChannelsPageSize;
}

void UChatDataManager::SetGetChannelsPageNumber(int32 Value)
{
    GetChannelsPageNumber = Value;
}

int32 UChatDataManager::GetGetChannelsPageNumber() const
{
    return GetChannelsPageNumber;
}

// Channel Query Params
void UChatDataManager::SetChannelQueryPrevSize(int32 Value)
{
    ChannelQueryPrevSize = Value;
}

int32 UChatDataManager::GetChannelQueryPrevSize() const
{
    return ChannelQueryPrevSize;
}

void UChatDataManager::SetChannelQueryNextSize(int32 Value)
{
    ChannelQueryNextSize = Value;
}

int32 UChatDataManager::GetChannelQueryNextSize() const
{
    return ChannelQueryNextSize;
}

void UChatDataManager::SetChannelQueryMessageId(const FString& Value)
{
    ChannelQueryMessageId = Value;
}

FString UChatDataManager::GetChannelQueryMessageId() const
{
    return ChannelQueryMessageId;
}

void UChatDataManager::SetChannelQueryOrder(const FString& Value)
{
    ChannelQueryOrder = Value;
}

FString UChatDataManager::GetChannelQueryOrder() const
{
    return ChannelQueryOrder;
}

void UChatDataManager::SetChannelQuerySelectChannelId(const FString& Value)
{
    ChannelQuerySelectChannelId = Value;
}

FString UChatDataManager::GetChannelQuerySelectChannelId() const
{
    return ChannelQuerySelectChannelId;
}

void UChatDataManager::SetMessageSelectViewChannelId(const FString& Value)
{
    MessageSelectViewChannelId = Value;
}

FString UChatDataManager::GetMessageSelectViewChannelId() const
{
    return MessageSelectViewChannelId;
}

// Set Translation Enabled Params
void UChatDataManager::SetSetTranslationEnabled(bool Value)
{
    SetTranslationEnabled = Value;
}

bool UChatDataManager::GetSetTranslationEnabled() const
{
    return SetTranslationEnabled;
}

// Reaction Params
void UChatDataManager::SetReactionMessageId(const FString& Value)
{
    ReactionMessageId = Value;
}

FString UChatDataManager::GetReactionMessageId() const
{
    return ReactionMessageId;
}

// Translate Params
void UChatDataManager::SetTranslateMessage(const FString& Value)
{
    TranslateMessage = Value;
}

FString UChatDataManager::GetTranslateMessage() const
{
    return TranslateMessage;
}

void UChatDataManager::SetTranslateTargetLanguages(const FString& Value)
{
    TranslateTargetLanguages = Value;
}

FString UChatDataManager::GetTranslateTargetLanguages() const
{
    return TranslateTargetLanguages;
}