/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"
#include "HiveChat.h"
#include "Types/HiveChatTypes.h"
#include "ChatDataManager.generated.h"

UENUM(BlueprintType)
enum class EChatAPI : uint8
{
    CHAT_CONNECT = 0,
    CHAT_RECONNECT,
    CHAT_DISCONNECT,
    CHAT_ISCONNECTED,
    CHAT_SEND_MESSAGE_TO_CHANNEL,
    CHAT_SEND_MESSAGE_TO_PLAYER,
    CHAT_CREATE_CHANNEL,
    CHAT_GET_CHANNELS,
    CHAT_GET_CHANNEL_INFO,
    CHAT_GET_CHANNEL_MEMBERS,
    CHAT_DELETE_CHANNEL,
    CHAT_ENTER_CHANNEL,
    CHAT_EXIT_CHANNEL,
    CHAT_GET_CHANNELS_BY_USER,
    CHAT_CHANNEL_QUERY,
    CHAT_CHANNEL_SET_TRANSLATION_ENABLED,
    CHAT_CHANNEL_ADD_REACTION,
    CHAT_CHANNEL_REMOVE_REACTION,
    CHAT_GET_BLOCK_MEMBERS,
    CHAT_BLOCK_MEMBER,
    CHAT_UNBLOCK_MEMBER,
    CHAT_TRANSLATE
};

/**
 * Chat API의 파라미터를 관리하는 싱글톤 클래스
 */
UCLASS(BlueprintType)
class HIVESDKV4TESTER_API UChatDataManager : public UObject
{
    GENERATED_BODY()

public:
    // 싱글톤 인스턴스 접근
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    static UChatDataManager* GetInstance();

    // SendMessage Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessageChannelId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetSendMessageChannelId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessageMessage(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetSendMessageMessage() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessageExtraData(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetSendMessageExtraData() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessagePlayerId(int64 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int64 GetSendMessagePlayerId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessageReplyMessageId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetSendMessageReplyMessageId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSendMessageMentionedPlayerIds(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetSendMessageMentionedPlayerIds() const;

    // Create Channel Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelChannelId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetCreateChannelChannelId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelPassword(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetCreateChannelPassword() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelChannelName(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetCreateChannelChannelName() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelMaxMemberCount(int32 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int32 GetCreateChannelMaxMemberCount() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelChannelType(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetCreateChannelChannelTypeString() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetCreateChannelChatHistoryAllowed(bool Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    bool GetCreateChannelChatHistoryAllowed() const;

    // Get Channels Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsChannelId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetGetChannelsChannelId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsChannelName(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetGetChannelsChannelName() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsPageOrder(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetGetChannelsPageOrder() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsPageSize(int32 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int32 GetGetChannelsPageSize() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsPageNumber(int32 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int32 GetGetChannelsPageNumber() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsChannelType(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetGetChannelsChannelTypeString() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetGetChannelsSortType(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetGetChannelsSortTypeString() const;

    // Channel Query Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetChannelQueryPrevSize(int32 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int32 GetChannelQueryPrevSize() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetChannelQueryNextSize(int32 Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    int32 GetChannelQueryNextSize() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetChannelQueryMessageId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetChannelQueryMessageId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetChannelQueryOrder(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetChannelQueryOrder() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetChannelQuerySelectChannelId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetChannelQuerySelectChannelId() const;

    // MessageSelectView용 현재 선택된 ChannelId
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetMessageSelectViewChannelId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetMessageSelectViewChannelId() const;

    // Set Translation Enabled Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetSetTranslationEnabled(bool Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    bool GetSetTranslationEnabled() const;

    // Reaction Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetReactionMessageId(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetReactionMessageId() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetReactionType(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetReactionTypeString() const;

    // Translate Params
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetTranslateMessage(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetTranslateMessage() const;

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    void SetTranslateTargetLanguages(const FString& Value);
    
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|DataManager")
    FString GetTranslateTargetLanguages() const;

    // 내부적으로 사용하는 enum 변환 함수들 (BlueprintCallable이 아님)
    EHiveChannelType GetCreateChannelChannelType() const;
    EHiveChannelType GetGetChannelsChannelType() const;
    EHiveSortType GetGetChannelsSortType() const;
    EHiveReactionType GetReactionType() const;

private:
    static UChatDataManager* Instance;

    // SendMessage Params
    UPROPERTY()
    FString SendMessageChannelId = "";
    
    UPROPERTY()
    FString SendMessageMessage = "";
    
    UPROPERTY()
    FString SendMessageExtraData = "";
    
    UPROPERTY()
    int64 SendMessagePlayerId = 0;
    
    UPROPERTY()
    FString SendMessageReplyMessageId = "";
    
    UPROPERTY()
    FString SendMessageMentionedPlayerIds = "";

    // Create Channel Params
    UPROPERTY()
    FString CreateChannelChannelId = "";
    
    UPROPERTY()
    FString CreateChannelPassword = "";
    
    UPROPERTY()
    FString CreateChannelChannelName = "";
    
    UPROPERTY()
    int32 CreateChannelMaxMemberCount = 0;
    
    UPROPERTY()
    FString CreateChannelChannelType = TEXT("UNKNOWN");
    
    UPROPERTY()
    bool CreateChannelChatHistoryAllowed = false;

    // Get Channels Params
    UPROPERTY()
    FString GetChannelsChannelId = "";
    
    UPROPERTY()
    FString GetChannelsChannelName = "";
    
    UPROPERTY()
    FString GetChannelsPageOrder = TEXT("NONE");
    
    UPROPERTY()
    int32 GetChannelsPageSize = 0;
    
    UPROPERTY()
    int32 GetChannelsPageNumber = 0;
    
    UPROPERTY()
    FString GetChannelsChannelType = TEXT("UNKNOWN");
    
    UPROPERTY()
    FString GetChannelsSortType = TEXT("Unknown");

    // Channel Query Params
    UPROPERTY()
    int32 ChannelQueryPrevSize = 0;
    
    UPROPERTY()
    int32 ChannelQueryNextSize = 0;
    
    UPROPERTY()
    FString ChannelQueryMessageId = "";
    
    UPROPERTY()
    FString ChannelQueryOrder = "";
    
    UPROPERTY()
    FString ChannelQuerySelectChannelId = "";

    UPROPERTY()
    FString MessageSelectViewChannelId = "";

    // Set Translation Enabled Params
    UPROPERTY()
    bool SetTranslationEnabled = false;

    // Reaction Params
    UPROPERTY()
    FString ReactionMessageId = "";
    
    UPROPERTY()
    FString ReactionType = TEXT("Like");

    // Translate Params
    UPROPERTY()
    FString TranslateMessage = "";
    
    UPROPERTY()
    FString TranslateTargetLanguages = "";
};