/* Copyright © 2025 Com2uS Platform Corp. All Rights Reserved. */

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Components/CheckBox.h"
#include "ChatDataManager.h"
#include "ChatParamView.generated.h"

DECLARE_DELEGATE(FOnChatParamConfirm);
DECLARE_DELEGATE(FOnChatParamCancel);

/**
 * Chat API 파라미터 입력을 위한 UI 위젯
 */
UCLASS()
class HIVESDKV4TESTER_API UChatParamView : public UUserWidget
{
    GENERATED_BODY()

public:
    // 파라미터 UI를 표시
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowParameters(EChatAPI API);

    // OK 버튼 클릭 시 호출
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void OnOKButtonClicked();

    // Cancel 버튼 클릭 시 호출
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void OnCancelButtonClicked();

    // 델리게이트
    FOnChatParamConfirm OnConfirmDelegate;
    FOnChatParamCancel OnCancelDelegate;

protected:
    // 각 API별 파라미터 UI 표시 함수들
    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowSendMessageToChannelParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowSendMessageToPlayerParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowCreateChannelParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowGetChannelsParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowChannelQueryParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowSetTranslationEnabledParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowReactionParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void ShowTranslateParams();

    UFUNCTION(BlueprintImplementableEvent, Category = "HIVE SDK V4|Chat|ParamView")
    void HideAllParams();

    // 파라미터 저장 함수들
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveSendMessageToChannelParams(const FString& ChannelId, const FString& Message, const FString& ExtraData, 
                                       const FString& ReplyMessageId, const FString& MentionedPlayerIds);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveSendMessageToPlayerParams(const FString& PlayerIdStr, const FString& Message, const FString& ExtraData);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveCreateChannelParams(const FString& ChannelId, const FString& Password, const FString& ChannelName,
                                const FString& MaxMemberCountStr, const FString& TypeStr, ECheckBoxState ChatHistoryAllowedState);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveGetChannelsParams(const FString& ChannelId, const FString& ChannelName, const FString& PageOrder,
                              const FString& PageSizeStr, const FString& PageNumberStr, const FString& TypeStr, const FString& SortTypeStr);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveChannelQueryParams(const FString& PrevSizeStr, const FString& NextSizeStr, const FString& MessageId, const FString& Order);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveSetTranslationEnabledParams(bool Enabled);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveReactionParams(const FString& MessageId, const FString& ReactionTypeStr);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void SaveTranslateParams(const FString& Message, const FString& TargetLanguages);

    // 현재 API 타입 가져오기
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    EChatAPI GetCurrentAPI() const { return CurrentAPI; }
    
    // 디버그용 - 현재 API를 문자열로 가져오기
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    FString GetCurrentAPIString() const;

    // 파라미터 로드 함수들
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadSendMessageToChannelParams(FString& ChannelId, FString& Message, FString& ExtraData, 
                                       FString& ReplyMessageId, FString& MentionedPlayerIds);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadSendMessageToPlayerParams(FString& PlayerIdStr, FString& Message, FString& ExtraData);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadCreateChannelParams(FString& ChannelId, FString& Password, FString& ChannelName,
                                FString& MaxMemberCountStr, FString& TypeStr, bool& ChatHistoryAllowed);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadGetChannelsParams(FString& ChannelId, FString& ChannelName, FString& PageOrder,
                              FString& PageSizeStr, FString& PageNumberStr, FString& TypeStr, FString& SortTypeStr);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadChannelQueryParams(FString& PrevSizeStr, FString& NextSizeStr, FString& MessageId, FString& Order);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadSetTranslationEnabledParams(bool& Enabled);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadReactionParams(FString& MessageId, FString& ReactionTypeStr);

    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    void LoadTranslateParams(FString& Message, FString& TargetLanguages);
    
    // ComboBox Options 가져오기 함수
    UFUNCTION(BlueprintCallable, Category = "HIVE SDK V4|Chat|ParamView")
    TArray<FString> GetReactionTypeOptions() const;

protected:
    UPROPERTY(BlueprintReadWrite, Category = "HIVE SDK V4|Chat|ParamView")
    EChatAPI CurrentAPI;
    
    // ShowParameters에서 설정된 원본 API 타입 저장
    UPROPERTY(BlueprintReadWrite, Category = "HIVE SDK V4|Chat|ParamView")
    EChatAPI OriginalAPI;

    UPROPERTY()
    UChatDataManager* DataManager;
};